package listener;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.JFileChooser;

import util.IO;
import util.ResourceManager;

import editor.SolistEditor;

import model.Play;

public class SaveProgramListener implements ActionListener {

	private static JFileChooser fChooser = null;

	public static JFileChooser getFileChooser() {
		if (fChooser == null) {
			String path = Play.getPlay().getDirectory() + File.separatorChar
					+ "programs";
			fChooser = new JFileChooser(path);
		}
		return fChooser;
	}

	public void actionPerformed(ActionEvent e) {
		Play play = Play.getPlay();
		JFileChooser chooser = getFileChooser();
		int returnVal = chooser.showSaveDialog(Play.getPlay().getPlayFrame());
		if (returnVal == JFileChooser.APPROVE_OPTION) {
			try {
				SolistEditor.getSolistEditor().save();
				File to = chooser.getSelectedFile();
				File from = new File(play.getDirectory() + File.separatorChar
						+ SolistEditor.CLASS_NAME + ".txt");
				IO.copyMediaFile(from, to);
				Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
						ResourceManager.getResourceManager().getValue(
								"msg.program.saved"));
			} catch (Throwable th) {
				if (!play.isSimulator()) {
					th.printStackTrace();
				}
			}
		} else {
			Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
					ResourceManager.getResourceManager().getValue(
							"msg.actioncanceled"));
		}

	}

}
