package listener;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

import model.ClassManager;
import model.Play;
import editor.Editor;

/**
 * Listener zum ffnen eines Java-Editors der selektierten Klasse
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class OpenEditorListener implements ActionListener {

	private int x;
	private int y;

	public OpenEditorListener(int x, int y) {
		this.x = x;
		this.y = y;
	}

	public void actionPerformed(ActionEvent e) {
		this.open();
	}

	/**
	 * ffnet den Editor
	 */
	public void open() {
		Play play = Play.getPlay();
		JTree fileTree = play.getPlayFrame().getFileTree();
		DefaultMutableTreeNode node = (DefaultMutableTreeNode) fileTree
				.getLastSelectedPathComponent();
		String fileName = node.getUserObject().toString();
		Editor editor = ClassManager.getClassManager().getClass(fileName)
				.getEditor();
		if (!editor.isOpen()) {
			editor.setLocation(Math.max(20, this.x - editor.getWidth() / 2),
					Math.max(20, this.y - editor.getHeight() / 2));
			editor.open();
		}
		editor.toFront();
	}

}
