package simulation;

import simulation.listener.EventObject;
import theater_intern.IStage;

public abstract class SimulationManager {

	private static SimulationManager simManager = null;

	public static SimulationManager getSimulationManager() {
		return simManager;
	}
	
	public static void setSimulationManager(SimulationManager man) {
		simManager = man;
	}

	public abstract void handleStart(boolean step);
	
	public abstract void setPause();
	
	public abstract void setStop();

	public abstract void handleStop();
	
	public abstract void handleStep();
	
	public abstract void handleEnd();
	
	public abstract void handleReset();
	
	public abstract void handleAPIStop();
	
	public abstract void handleAPISuspend();
	
	public abstract void insertEventObject(EventObject obj);
	
	public abstract void executeEventQueue();
	
	public abstract void setStage(IStage stage);
	
	public abstract Thread getSimulator();
	
	public abstract void cancelSimulator();
	
	public abstract void setButtonsToStart();

}
