import theater.*;

import java.awt.Color;

/**
 * Die Klasse stellt eine Repraesentation der Turtle-Welt dar.
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 1.0 (30.09.2009)
 *
 */
public class PaintArea extends Stage {
    private Color bgColor;

    public PaintArea() {
        super(800, 600, 1);
        bgColor = Color.WHITE;

        TheaterImage bg = new TheaterImage(800, 600);
        bg.setColor(bgColor);
        bg.fill();
        setBackground(bg);

        setSolist(Actor.createSolist(), getNumberOfColumns() / 2,
            getNumberOfRows() / 2); // in the middle of the stage
    }

    void changeBackgroundColor(Color color) {
        Performance.getPerformance().lock();

        try {
            TheaterImage bg = getBackground();
            bg.setColor(color);
            bg.fill();
            bgColor = color;
            ((Turtle) getSolist()).changeNotVisibleColor();
            this.paint();
        } finally {
            Performance.getPerformance().unlock();
        }
    }

    Color getBackgroundColor() {
        Performance.getPerformance().lock();

        try {
            return bgColor;
        } finally {
            Performance.getPerformance().unlock();
        }
    }
    
    void clean() {
        Performance.getPerformance().lock();

        try {
            TheaterImage bg = getBackground();
            bg.setColor(bgColor);
            bg.fill();
            ((Turtle) getSolist()).changeNotVisibleColor();
            this.paint();
        } finally {
            Performance.getPerformance().unlock();
        }
    }
}
