import theater.*;


/**
 * Repraesentation des Hanoi-Solisten bzw. der Befehle
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 1.0 (30.09.2009)
 *
 */
public class Spieler extends Actor {
    final static int GESCHWINDIGKEIT = 10;

    // Default-Konstruktor (muss implementiert werden!)
    public Spieler() {
        super(); // nicht loeschen!
        setVisible(false);
    }

    // Copy-Konstruktor (muss implementiert werden!)
    public Spieler(Spieler actor) {
        super(actor); // nicht loeschen!
        setVisible(false);
    }

    @Description("<html>Verschiebe die oberste Scheibe.<br>" +
    "Erster Parameter: Nummer des von-Stabs (0-2).<br>" +
    "Zweiter Parameter: Nummer des nach-Stabs (0-2).<br>" +
    "Fehler, wenn die Regeln verletzt werden.</html>")
    public void verschiebe(int von, int nach) {
        Performance.getPerformance().lock();

        try {
            ueberpruefeStab(von);
            ueberpruefeStab(nach);

            if (von == nach) {
                throw new UngueltigerZugException();
            }

            if (istLeer(von)) {
                throw new StabIstLeerException(von);
            }

            Spielfeld feld = (Spielfeld) getStage();
            Stab vonStab = feld.liefereStab(von);
            Stab nachStab = feld.liefereStab(nach);
            Scheibe scheibe = vonStab.entferneObersteScheibe();
            int scheibenGroesse = scheibe.liefereNummer();
            int obersteGroesse = anzahlScheiben();

            if (!nachStab.istLeer()) {
                obersteGroesse = nachStab.liefereObersteScheibe().liefereNummer();
            }

            nachStab.legeNeueScheibe(scheibe);

            int nachSpalte = nachStab.getColumn();

            int nachReihe = getStage().getNumberOfRows() -
                (((nachStab.liefereAnzahlScheiben() - 1) * Scheibe.HOEHE) +
                (Scheibe.HOEHE / 2));
            bewegen(scheibe, nachStab, nachSpalte, nachReihe);

            if (scheibenGroesse > obersteGroesse) {
                throw new UngueltigerZugException();
            }
        } finally {
            Performance.getPerformance().unlock();
        }
    }

    @Description("Liefert die Gesamtanzahl an Scheiben.")
    public int anzahlScheiben() {
        Performance.getPerformance().lock();

        try {
            return ((Spielfeld) getStage()).liefereScheibenAnzahl();
        } finally {
            Performance.getPerformance().unlock();
        }
    }

    @Description("berprft, ob der Stab (Nummer 0 - 2) leer ist.")
    public boolean istLeer(int stab) {
        Performance.getPerformance().lock();

        try {
            ueberpruefeStab(stab);

            return hoehe(stab) == 0;
        } finally {
            Performance.getPerformance().unlock();
        }
    }

    @Description("Liefert die Gre der obersten Scheibe des angegebenen Stabes (Nummer 0 - 2).")
    public int obersteScheibe(int stab) {
        Performance.getPerformance().lock();

        try {
            ueberpruefeStab(stab);

            if (istLeer(stab)) {
                throw new StabIstLeerException(stab);
            }

            return ((Spielfeld) getStage()).liefereStab(stab)
                    .liefereObersteScheibe().liefereNummer();
        } finally {
            Performance.getPerformance().unlock();
        }
    }

    @Invisible
    int hoehe(int stab) {
        return ((Spielfeld) getStage()).liefereStab(stab).liefereAnzahlScheiben();
    }

    @Invisible
    void ueberpruefeStab(int stab) {
        if ((stab < 0) || (stab > 2)) {
            throw new UngueltigerStabException(stab);
        }
    }

    @Invisible
    void bewegen(Scheibe scheibe, Stab nachStab, int nachSpalte, int nachReihe) {
        int naechsteReihe = scheibe.getRow() - GESCHWINDIGKEIT;

        while (naechsteReihe >= (Scheibe.HOEHE / 2)) {
            scheibe.setLoc(scheibe.getColumn(), naechsteReihe);
            naechsteReihe = scheibe.getRow() - 5;
        }

        scheibe.setLoc(scheibe.getColumn(), Scheibe.HOEHE / 2);

        if (scheibe.getColumn() > nachStab.getColumn()) {
            int naechsteSpalte = scheibe.getColumn() - GESCHWINDIGKEIT;

            while (naechsteSpalte >= nachSpalte) {
                scheibe.setLoc(naechsteSpalte, scheibe.getRow());
                naechsteSpalte = scheibe.getColumn() - GESCHWINDIGKEIT;
            }
        } else {
            int naechsteSpalte = scheibe.getColumn() + GESCHWINDIGKEIT;

            while (naechsteSpalte <= nachSpalte) {
                scheibe.setLoc(naechsteSpalte, scheibe.getRow());
                naechsteSpalte = scheibe.getColumn() + GESCHWINDIGKEIT;
            }
        }

        scheibe.setLoc(nachSpalte, scheibe.getRow());

        naechsteReihe = scheibe.getRow() + GESCHWINDIGKEIT;

        while (naechsteReihe <= nachReihe) {
            scheibe.setLoc(scheibe.getColumn(), naechsteReihe);
            naechsteReihe = scheibe.getRow() + GESCHWINDIGKEIT;
        }

        scheibe.setLoc(scheibe.getColumn(), nachReihe);
    }
}
