import theater.*;

import java.awt.Color;


/**
 * Die Klasse stellt eine Repraesentation des GameOfLife-Spielfeldes dar.
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 1.0 (05.10.2009)
 *
 */
public class Spielfeld extends Stage {
    // Gre einer Zelle in Pixeln
    final static int CELLSIZE = 20;
    TheaterImage bg;

    public Spielfeld() {
        super(20, 20, CELLSIZE);

        bg = new TheaterImage(CELLSIZE, CELLSIZE);
        bg.setColor(Color.WHITE); // Defaultfarbe des Hintergrund
        bg.fill();
        setBackground(bg);

        setSolist(Actor.createSolist(), 0, 0);

        // Solist ist unsichtbar
    }

    // ndert die Hintergrundfarbe
    void changeBackgroundColor(Color color) {
        Performance.getPerformance().lock();

        try {
            bg.setColor(color);
            bg.fill();
            this.paint();
        } finally {
            Performance.getPerformance().unlock();
        }
    }

    // liefert die aktuelle Hintergrundfarbe
    Color getBackgroundColor() {
        Performance.getPerformance().lock();

        try {
            return bg.getColor();
        } finally {
            Performance.getPerformance().unlock();
        }
    }

    // berprft Reihenindex
    void checkRow(int row) throws RuntimeException {
        if ((row < 0) || (row >= getNumberOfRows())) {
            throw new RuntimeException(row + " = ungltige Reihe");
        }
    }

    // berprft Spaltenindex
    void checkCol(int col) throws RuntimeException {
        if ((col < 0) || (col >= getNumberOfColumns())) {
            throw new RuntimeException(col + " = ungltige Spalte");
        }
    }
}
