import theater.*;

import java.awt.Color;
import java.awt.Graphics;


/**
 * Die Klasse reprsentiert einen Zhler auf der Bhne.
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 1.0 (22.10.2009)
 *
 */
public class Counter extends Prop {
    private static final Color textColor = new Color(0, 0, 0);
    private int value = 0;
    private String text;
    private int stringLength;

    Counter() {
        this("");
    }

    Counter(String prefix) {
        text = prefix;
        setImage(new TheaterImage((text.length() + 4) * 10, 16));
        getImage().setColor(textColor);
        updateImage();
    }

    void add(int score) {
        value += score;
        updateImage();
    }

    void subtract(int score) {
        value -= score;
        updateImage();
    }

    int getValue() {
        return value;
    }

    void updateImage() {
        TheaterImage image = getImage();
        image.clear();
        image.drawString(text + value, 1, 12);
    }
}
