import theater.*;


/**
 * Die Klasse stellt eine Repraesentation der schwarzen Kacheln dar.
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 1.0 (07.10.2009)
 *
 */
public class KachelSchwarz extends Prop {
    private boolean added = false;

    public KachelSchwarz() {
        setImage("kachel-schwarz.gif");
    }

    @Invisible
    @Override
    public void addedToStage(Stage stage) {
        added = true;
    }

    @Invisible
    @Override
    public void setLocation(int col, int row) {
        if (added) {
            return;
        }

        super.setLocation(col, row);
    }
}
