import theater.*;

import java.util.List;


/**
 * Repraesentation des Hanoi-Spielfeldes
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 1.0 (30.09.2009)
 *
 */
public class Spielfeld extends Stage {
    final static int MAX_SCHEIBEN = 9;
    Stab[] staebe;
    private int scheibenAnzahl = 4;

    public Spielfeld() {
        super(660, 400, 1);

        // Solist ist unsichtbar
        setSolist(Actor.createSolist(), getNumberOfColumns() / 2,
            getNumberOfRows() / 2);

        staebe = new Stab[3];

        for (int i = 0; i < staebe.length; i++) {
            staebe[i] = new Stab(i);
            add(staebe[i], 120 + (i * 210), 300);
        }

        initialisieren();
    }

    Stab liefereStab(int nummer) {
        return staebe[nummer];
    }

    int liefereScheibenAnzahl() {
        return scheibenAnzahl;
    }

    void setzeScheibenAnzahl(int anzahl) {
        HanoiPerformance perf = (HanoiPerformance) Performance.getPerformance();

        if (perf.isRunning()) {
            return;
        }

        Performance.getPerformance().lock();

        try {
            loeschen();
            scheibenAnzahl = anzahl;
            initialisieren();
        } finally {
            Performance.getPerformance().unlock();
        }
    }

    private void loeschen() {
        List<Component> scheiben = getComponents(Scheibe.class);
        remove(scheiben);

        for (int i = 0; i < staebe.length; i++) {
            staebe[i].leeren();
        }
    }

    private void initialisieren() {
        for (int i = scheibenAnzahl; i > 0; i--) {
            staebe[0].legeNeueScheibe(new Scheibe(i));
        }

        List<Scheibe> scheiben = staebe[0].liefereScheiben();

        for (int i = 1; i <= scheiben.size(); i++) {
            add(scheiben.get(scheiben.size() - i), staebe[0].getColumn(),
                getNumberOfRows() -
                (((i - 1) * Scheibe.HOEHE) + (Scheibe.HOEHE / 2)));
        }
    }
}
