import theater.*;

import java.util.List;


/**
 * Objekte dieser Requisitenklasse reprsentieren ein Wasserfeld
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 1.0 (24.09.2009)
 *
 */
public class Wasser extends Prop {
    public Wasser() {
        // ordnet der Requisite ein Wasser-Ikon zu
        setImage("wasser.gif");
    }

    // berschreibt die geerbte Methode, die zum Setzen der Position dient
    @Invisible // soll nicht im Popup-Men sichtbar sein

    public void setLocation(int col, int row) {
        Performance.getPerformance().lock();

        try {
            int oldCol = this.getColumn();
            int oldRow = this.getRow();

            // neue Kachel ist bereits die aktuelle Kachel
            if ((oldCol == col) && (oldRow == row)) {
                return;
            }

            // auerhalb des Territoriums
            if ((col < 0) || (row < 0) ||
                    (col >= getStage().getNumberOfColumns()) ||
                    (row >= getStage().getNumberOfRows())) {
                return;
            }

            List<Component> comps = getStage()
                                        .getComponentsAt(col, row, Wasser.class);

            if (comps.size() > 0) {
                // bereits Wasser da
                return;
            }

            // wenn ein Wasser-Ikon  verschoben wird, muss u.U. das Frosch-Ikon angepasst werden
            List<Component> oldComps = getStage()
                                           .getComponentsAt(oldCol, oldRow,
                    Frosch.class);

            if (oldComps.size() > 0) {
                // Frosch sitzt wieder auf dem Gras
                ((Frosch)oldComps.get(0)).changeImage(true);
            }

            comps = getStage().getComponentsAt(col, row, Frosch.class);

            if (comps.size() > 0) {
                // Frosch sitzt nun im Wasser
                ((Frosch)comps.get(0)).changeImage(false);
            }

            super.setLocation(col, row);
        } finally {
            Performance.getPerformance().unlock();
        }
    }
}
