import theater.*;


public class Mauer extends Prop {
    public Mauer() {
        setImage("mauer.png");
    }

    @Invisible
    public void setLocation(int col, int row) {
        Performance.getPerformance().lock();

        try {
            if ((this.getColumn() == col) && (this.getRow() == row)) {
                // die Mauer befindet sich bereits auf dieser Zelle
                return;
            }

            if ((col < 0) || (row < 0) ||
                    (col >= this.getStage().getNumberOfColumns()) ||
                    (row >= this.getStage().getNumberOfRows())) {
                // nur innerhalb der sichtbaren Bhne 
                return;
            }

            Actor solist = getStage().getSolist();

            if ((col == solist.getColumn()) && (row == solist.getRow())) {
                // Mauer kann nicht auf die Zelle umplatziert werden, auf der
                // sich der Solist befindet
                return;
            }

            // Mauer auf Kachel?
            if (this.getStage().getComponentsAt(col, row, Mauer.class).size() > 0) {
                // eine Mauer kann nicht auf eine Kachel platziert werden, auf der sich
                // bereits eine Mauer befindet
                return;
            }

            // ruft die geerbte Methode auf, die die tatschliche Umplatzierung
            // vornimmt
            super.setLocation(col, row);
        } finally {
            Performance.getPerformance().unlock();
        }
    }
}
