import theater.*;


/**
 * Die Klasse stellt eine Repraesentation des Spielfeldes (Schachbrett) dar.
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 1.0 (07.10.2009)
 *
 */
public class Spielfeld extends Stage {
    final static int MIN_SIZE = 1;
    final static int MAX_SIZE = 8;
    final static int CELL_SIZE = 50;
    boolean[][] feld;

    public Spielfeld() {
        super(MAX_SIZE, MAX_SIZE, CELL_SIZE);
        setBackground("kachel-weiss.gif");

        for (int r = 0; r < MAX_SIZE; r += 2) {
            for (int s = 1; s < MAX_SIZE; s += 2) {
                add(new KachelSchwarz(), s, r);
            }
        }

        for (int r = 1; r < MAX_SIZE; r += 2) {
            for (int s = 0; s < MAX_SIZE; s += 2) {
                add(new KachelSchwarz(), s, r);
            }
        }

        // erzeugt den Solist und platziert in mitten auf der Bhne
        setSolist(Actor.createSolist(), 0, 0);

        feld = new boolean[MAX_SIZE][MAX_SIZE];

        // keine Dame vorhanden
        for (int r = 0; r < MAX_SIZE; r++) {
            for (int s = 0; s < MAX_SIZE; s++) {
                feld[r][s] = false;
            }
        }
    }

    void setSize(int size) {
        setSize(size, size);
    }

    int getSize() {
        return getNumberOfRows();
    }

    // berprft, ob auf dem angegebenen Feld eine Dame platziert werden kann
    boolean checkSetDame(int row, int col) {
        int size = getSize();

        // check Reihen
        for (int r = 0; r < size; r++) {
            if (feld[r][col]) {
                return false;
            }
        }

        // check Spalten
        for (int s = 0; s < size; s++) {
            if (feld[row][s]) {
                return false;
            }
        }

        // check Diagonalen
        int r = row;
        int s = col;

        while ((r >= 0) && (s >= 0)) {
            if (feld[r][s]) {
                return false;
            }

            r--;
            s--;
        }

        r = row;
        s = col;

        while ((r < size) && (s >= 0)) {
            if (feld[r][s]) {
                return false;
            }

            r++;
            s--;
        }

        r = row;
        s = col;

        while ((r >= 0) && (s < size)) {
            if (feld[r][s]) {
                return false;
            }

            r--;
            s++;
        }

        r = row;
        s = col;

        while ((r < size) && (s < size)) {
            if (feld[r][s]) {
                return false;
            }

            r++;
            s++;
        }

        return true;
    }

    // setzt Dame in der internen Reprsentation
    void setDame(int row, int col) {
        feld[row][col] = true;
    }

    // berprft Dame internen Reprsentation
    boolean isDame(int row, int col) {
        return feld[row][col];
    }

    // entfernt Dame in der internen Reprsentation
    void removeDame(int row, int col) {
        feld[row][col] = false;
    }

    @Override
    public void add(Prop prop, int col, int row) {
        // whrend eine Simulation luft, drfen Damen nur vom virtuellen
        // Spieler hinzugefgt werden
        if (prop.getClass() == Dame.class) {
            MyPerformance perf = (MyPerformance) Performance.getPerformance();
            Spieler spieler = (Spieler) perf.getActiveStage().getSolist();

            if (perf.isRunning() && !spieler.isActive()) {
                return;
            }
        }

        super.add(prop, col, row);
    }

    @Override
    public void remove(Component comp) {
        if (comp.getClass() == KachelSchwarz.class) {
            return; // Kacheln drfen nicht gelscht werden
        }

        // whrend eine Simulation luft, drfen Damen nur vom virtuellen
        // Spieler entfernt werden
        if (comp.getClass() == Dame.class) {
            MyPerformance perf = (MyPerformance) Performance.getPerformance();
            Spieler spieler = (Spieler) perf.getActiveStage().getSolist();

            if (perf.isRunning() && !spieler.isActive()) {
                return;
            } else if (((Dame) comp).added) {
                removeDame(comp.getRow(), comp.getColumn());
            }
        }

        super.remove(comp);
    }
}
