package view;

import java.io.IOException;
import java.net.URL;

import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.WindowConstants;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

/**
 * Realisiert einen einfachen Webbrowser
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class WebBrowser extends JEditorPane implements HyperlinkListener {
	public WebBrowser(String title, URL url) {
		try {
			this.setEditable(false);
			this.addHyperlinkListener(this);
			this.setPage(url);
			JFrame f = new JFrame(title);
			f.setDefaultCloseOperation(WindowConstants.HIDE_ON_CLOSE);
			f.setLocation(10, 10);
			f.setSize(1000, 800);
			f.add(new JScrollPane(this));
			f.setVisible(true);
		} catch (Throwable e) {
			e.printStackTrace();
			return;
		}
	}

	public WebBrowser(String title, String url) {
		try {
			this.setEditable(false);
			this.addHyperlinkListener(this);
			this.setPage(new URL(url));
			JFrame f = new JFrame(title);
			f.setDefaultCloseOperation(WindowConstants.HIDE_ON_CLOSE);
			f.setLocation(10, 10);
			f.setSize(1000, 800);
			f.add(new JScrollPane(this));
			f.setVisible(true);
		} catch (Throwable e) {
			e.printStackTrace();
			return;
		}
	}

	public void hyperlinkUpdate(HyperlinkEvent event) {
		HyperlinkEvent.EventType typ = event.getEventType();
		if (typ == HyperlinkEvent.EventType.ACTIVATED) {
			try {
				this.setPage(event.getURL());
			} catch (IOException e) {
				JOptionPane.showMessageDialog(this, "Invalid Link: "
						+ event.getURL().toExternalForm(), "Error",
						JOptionPane.ERROR_MESSAGE);
			}
		}
	}
}