package view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;

import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;
import javax.swing.WindowConstants;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeSelectionModel;

import listener.DebuggerListener;
import listener.FileTreePopupListener;
import listener.GenerateListener;
import listener.IFrameVisible;
import listener.LoadImageListener;
import listener.LoadProgramListener;
import listener.LoadSoundListener;
import listener.LoadStageListener;
import listener.NewActionButtonListener;
import listener.NewPlayListener;
import listener.OpenPlayListener;
import listener.ParadigmaListener;
import listener.QuitListener;
import listener.SavePlayListener;
import listener.SaveProgramListener;
import listener.SaveStageAsGifListener;
import listener.SaveStageAsJpgListener;
import listener.SaveStageAsPngListener;
import listener.SaveStageListener;
import listener.SpeedListener;
import listener.WindowVisible;
import model.ActionButton;
import model.ActionButtonClass;
import model.ClassManager;
import model.Play;
import model.TheaterClass;
import simulation.ActSimulationManager;
import simulation.SimulationManager;
import theater.Performance;
import util.PropertyManager;
import util.ResourceLoader;
import util.ResourceManager;
import util.Utils;

import compiler.CompileManager;

import console.Console;
import debugger.DebuggerFrame;
import editor.Editor;
import editor.SolistEditor;
import editor.SolistEditorObserver;

public class PlayFrame extends JFrame implements WindowListener, Observer {

	JMenuBar menuBar;

	JMenu playMenu;
	JMenu controlsMenu;
	JMenu mediaMenu;
	JMenu programMenu;
	JMenu stageMenu;
	JMenu windowMenu;
	JMenu helpMenu;

	JMenu openRecentSubMenu;

	JMenuItem newMenuItem;
	JMenuItem openMenuItem;
	JMenuItem openRecentMenuItem;
	JMenuItem closeMenuItem;
	JMenuItem saveMenuItem;
	JMenuItem saveAsMenuItem;
	JMenuItem generateMenuItem;
	JMenuItem actionMenuItem;
	JMenuItem quitMenuItem;

	JMenuItem recent1;
	JMenuItem recent2;

	JMenuItem imagesMenuItem;
	JMenuItem audioMenuItem;

	JMenuItem manualMenuItem;
	JMenuItem pdfManualMenuItem;
	JMenuItem apiMenuItem;
	JMenuItem aboutMenuItem;

	JMenuItem programSaveMenuItem;
	JMenuItem compileItem;
	JMenuItem programLoadMenuItem;
	JMenuItem printMenuItem;
	JMenuItem stageSaveMenuItem;
	JMenuItem stageLoadMenuItem;
	JMenuItem indentMenuItem;
	JCheckBoxMenuItem paradigmaMenuItem;

	JMenu fontsizeMenu;
	JMenuItem undoMenuItem;
	JMenuItem redoMenuItem;
	JMenuItem cutMenuItem;
	JMenuItem copyMenuItem;
	JMenuItem pasteMenuItem;

	JMenu stageImageSaveMenu;
	JMenuItem stagePngSaveMenuItem;
	JMenuItem stageGifSaveMenuItem;
	JMenuItem stageJpgSaveMenuItem;

	JMenuItem genAboutMenuItem;
	JMenuItem handbookOnlineMenuItem;
	JMenuItem handbookOfflineMenuItem;

	JToolBar toolBar;

	JButton newButton;
	JButton openButton;
	JButton saveButton;
	JButton infoButton;
	JButton compileButton;
	JButton runButton;
	JButton pauseButton;
	JButton stopButton;
	JButton backButton;
	JButton resetButton;
	JToggleButton debuggerButton;
	JButton stepButton;
	JSlider speedSlider;

	JButton printButton;
	JButton cutButton;
	JButton copyButton;
	JButton pasteButton;
	JButton undoButton;
	JButton redoButton;

	JMenuItem runMenuItem;
	JMenuItem pauseMenuItem;
	JMenuItem stopMenuItem;
	JMenuItem backMenuItem;
	JMenuItem resetMenuItem;
	JMenuItem stepMenuItem;
	JCheckBoxMenuItem debugMenuItem;

	JCheckBoxMenuItem consoleMenuItem;
	JCheckBoxMenuItem iFrameMenuItem;
	JCheckBoxMenuItem debuggerFrameMenuItem;

	SolistEditor solistEditor;
	JSplitPane solistEditorSplitPane;

	Color compileBackgroundColor;
	boolean compiled;

	JPanel fileTreeSurrounding;
	FileTree fileTree;
	FilePopupMenu filePopupMenu1;
	JPopupMenu dirPopupMenu;
	StagePanel stage;
	JScrollPane stageScrollPane;

	TheaterGlassPane glassPane;

	MessagePanel messagePanel;

	ResourceManager resourceManager;

	Play play;

	ActSimulationManager simulationManager;

	public PlayFrame(Play play) {
		super(!play.isEmpty() ? ((play.isSimulator() ? "" : "Solist - ") + play
				.getName()) : "Solist");
		this.setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
		this.play = play;
		this.compiled = true;
		this.addWindowListener(this);
		this.setLayout(new BorderLayout());
		this.resourceManager = ResourceManager.getResourceManager();
		CompileManager.getCompileManager().addObserver(this);
		this.solistEditor = SolistEditor.getSolistEditor();

		this.initComponents();
		this.glassPane = TheaterGlassPane.getPane();
		this.setGlassPane(this.glassPane);
		this.glassPane.setVisible(false);

		this.handleSimulation();

		this.setFocusable(true);
		this.pack();
		Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
		this.setLocation((d.width - this.getSize().width) / 2, (d.height - this
				.getSize().height) / 2);
	}

	public MessagePanel getMessagePanel() {
		return this.messagePanel;
	}

	public JButton getCompileButton() {
		return this.compileButton;
	}

	public JMenuItem getCompileItem() {
		return this.compileItem;
	}

	public JButton getResetButton() {
		return this.resetButton;
	}

	public JToggleButton getDebuggerButton() {
		return this.debuggerButton;
	}

	public JButton getStepButton() {
		return this.stepButton;
	}

	public StagePanel getStagePanel() {
		return this.stage;
	}

	public FileTree getFileTree() {
		return this.fileTree;
	}

	public TheaterGlassPane getGlassPane() {
		return this.glassPane;
	}

	public JScrollPane getStageScrollPane() {
		return this.stageScrollPane;
	}

	protected void initComponents() {
		this.initMenues();
		this.initToolBar();
		this.initSolistEditor();
		this.initFileTree();
		this.initStage();
		this.initMessagePanel();

		if (!this.play.isSimulator()) {
			JSplitPane splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
			splitPane
					.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
			JScrollPane fts = new JScrollPane(this.fileTreeSurrounding);
			fts.setMinimumSize(new Dimension(100, 0));
			fts.setPreferredSize(new Dimension(150, 200));
			splitPane.setRightComponent(fts);
			splitPane.setLeftComponent(this.stageScrollPane = new JScrollPane(
					this.stage));
			splitPane.setOneTouchExpandable(true);
			splitPane.setContinuousLayout(true);
			splitPane.setResizeWeight(1);

			JSplitPane splitPane2 = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
			splitPane2.setBorder(BorderFactory
					.createLineBorder(Color.DARK_GRAY));

			splitPane2.setLeftComponent(this.solistEditorSplitPane);
			splitPane2.setRightComponent(splitPane);
			splitPane2.setOneTouchExpandable(true);
			splitPane2.setContinuousLayout(true);

			this.add(splitPane2, BorderLayout.CENTER);
			this.add(this.messagePanel, BorderLayout.SOUTH);
		} else {

			JSplitPane splitPane2 = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
			splitPane2.setBorder(BorderFactory
					.createLineBorder(Color.DARK_GRAY));

			splitPane2.setLeftComponent(this.solistEditorSplitPane);
			splitPane2
					.setRightComponent(this.stageScrollPane = new JScrollPane(
							this.stage));
			splitPane2.setOneTouchExpandable(true);
			splitPane2.setContinuousLayout(true);

			this.add(splitPane2, BorderLayout.CENTER);
			this.add(this.messagePanel, BorderLayout.SOUTH);
		}

	}

	void initSolistEditor() {
		JPanel editorPanelSurrounding = new JPanel();
		editorPanelSurrounding.setBorder(BorderFactory
				.createLineBorder(Color.DARK_GRAY));
		editorPanelSurrounding.setBackground(new Color(255, 255, 220));
		editorPanelSurrounding.setLayout(new BorderLayout());
		editorPanelSurrounding.add(Box.createRigidArea(new Dimension(2, 2)),
				BorderLayout.NORTH);
		editorPanelSurrounding.add(Box.createRigidArea(new Dimension(2, 2)),
				BorderLayout.SOUTH);
		editorPanelSurrounding.add(Box.createRigidArea(new Dimension(2, 2)),
				BorderLayout.WEST);
		editorPanelSurrounding.add(Box.createRigidArea(new Dimension(2, 2)),
				BorderLayout.EAST);

		JScrollPane scrollEdP = new JScrollPane(this.solistEditor
				.getEditorPanel());
		scrollEdP.setPreferredSize(new Dimension(400, 400));
		scrollEdP.getViewport().setBackground(Color.WHITE);
		scrollEdP.setRowHeaderView(this.solistEditor.getLineNumberPanel());
		// editorPanelSurrounding.add(scrollEdP, BorderLayout.CENTER);

		JPanel errorPaneSurrounding = new JPanel();
		errorPaneSurrounding.setBorder(BorderFactory
				.createLineBorder(Color.DARK_GRAY));
		errorPaneSurrounding.setBackground(new Color(255, 255, 220));
		errorPaneSurrounding.setLayout(new BorderLayout());
		errorPaneSurrounding.add(Box.createRigidArea(new Dimension(2, 2)),
				BorderLayout.NORTH);
		errorPaneSurrounding.add(Box.createRigidArea(new Dimension(2, 2)),
				BorderLayout.SOUTH);
		errorPaneSurrounding.add(Box.createRigidArea(new Dimension(2, 2)),
				BorderLayout.WEST);
		errorPaneSurrounding.add(Box.createRigidArea(new Dimension(2, 2)),
				BorderLayout.EAST);

		JScrollPane scrollErP = new JScrollPane(this.solistEditor
				.getErrorPanel());
		scrollErP.setPreferredSize(new Dimension(400, 80));
		scrollErP.getViewport().setBackground(Color.WHITE);
		// errorPaneSurrounding.add(scrollErP, BorderLayout.CENTER);

		this.solistEditorSplitPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
		this.solistEditorSplitPane.setBorder(BorderFactory
				.createLineBorder(Color.DARK_GRAY));
		this.solistEditorSplitPane.setTopComponent(scrollEdP);
		this.solistEditorSplitPane.setBottomComponent(scrollErP);
		this.solistEditorSplitPane.setOneTouchExpandable(true);
		this.solistEditorSplitPane.setContinuousLayout(true);
		this.solistEditorSplitPane.setResizeWeight(1);
		HierarchyListener hierarchyListener = new HierarchyListener() {
			public void hierarchyChanged(HierarchyEvent e) {
				long flags = e.getChangeFlags();
				if ((flags & HierarchyEvent.SHOWING_CHANGED) == HierarchyEvent.SHOWING_CHANGED) {
					PlayFrame.this.solistEditorSplitPane
							.setDividerLocation(1.0);
				}
			}
		};
		this.solistEditorSplitPane.addHierarchyListener(hierarchyListener);

		this.solistEditor.getEditor().addObserver(
				new SolistEditorObserver(this.solistEditor));
	}

	protected void initMenues() {
		this.menuBar = new JMenuBar();
		this.initPlayMenu();
		if (!this.play.isSimulator()) {
			this.menuBar.add(this.playMenu);
		}

		this.mediaMenu = new JMenu(this.resourceManager
				.getValue("menu.media.text"));
		this.initMediaMenu();
		if (!this.play.isSimulator()) {
			this.menuBar.add(this.mediaMenu);
		}
		if (this.play.isEmpty()) {
			this.mediaMenu.setEnabled(false);
		}

		this.programMenu = new JMenu(this.resourceManager
				.getValue("menu.program.text"));
		this.initProgramMenu();
		this.menuBar.add(this.programMenu);
		if (this.play.isEmpty()) {
			this.programMenu.setEnabled(false);
		}

		this.stageMenu = new JMenu(this.resourceManager
				.getValue("menu.stage.text"));
		this.initStageMenu();
		this.menuBar.add(this.stageMenu);
		if (this.play.isEmpty()) {
			this.stageMenu.setEnabled(false);
		}

		this.controlsMenu = new JMenu(this.resourceManager
				.getValue("menu.controls.text"));
		this.initControlsMenu();
		this.menuBar.add(this.controlsMenu);
		if (this.play.isEmpty()) {
			this.controlsMenu.setEnabled(false);
		}

		this.windowMenu = new JMenu(this.resourceManager
				.getValue("menu.window.text"));
		this.initWindowMenu();
		this.menuBar.add(this.windowMenu);
		if (this.play.isEmpty()) {
			this.windowMenu.setEnabled(false);
		}

		if (!this.play.isSimulator()) {
			this.helpMenu = new JMenu(this.resourceManager
					.getValue("menu.help.text"));
			this.initHelpMenu();
			this.menuBar.add(this.helpMenu);
		} else {
			this.helpMenu = new JMenu(this.resourceManager
					.getValue("menu.help.text"));
			this.initSimulatorHelpMenu();
			this.menuBar.add(this.helpMenu);
		}

		this.setJMenuBar(this.menuBar);
	}

	protected void initPlayMenu() {
		this.playMenu = new JMenu(this.resourceManager
				.getValue("menu.play.text"));

		this.newMenuItem = new JMenuItem();
		this.newMenuItem
				.setText(this.resourceManager.getValue("play.new.text"));
		this.newMenuItem.setToolTipText(this.resourceManager
				.getValue("play.new.tooltip"));
		this.newMenuItem.setMnemonic(this.resourceManager.getValue(
				"play.new.mnemonic").charAt(0));
		this.newMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("play.new.keystroke")));
		this.newMenuItem.addActionListener(NewPlayListener.getNewPlayManager());
		this.playMenu.add(this.newMenuItem);

		this.openMenuItem = new JMenuItem();
		this.openMenuItem.setText(this.resourceManager
				.getValue("play.open.text"));
		this.openMenuItem.setToolTipText(this.resourceManager
				.getValue("play.open.tooltip"));
		this.openMenuItem.setMnemonic(this.resourceManager.getValue(
				"play.open.mnemonic").charAt(0));
		this.openMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("play.open.keystroke")));
		this.openMenuItem.addActionListener(OpenPlayListener
				.getOpenPlayManager());
		this.playMenu.add(this.openMenuItem);

		this.openRecentMenuItem = new JMenuItem();
		this.createOpenRecentSubMenu();
		// playMenu.add(openRecentSubMenu);

		this.closeMenuItem = new JMenuItem();
		this.closeMenuItem.setText(this.resourceManager
				.getValue("play.close.text"));
		this.closeMenuItem.setToolTipText(this.resourceManager
				.getValue("play.close.tooltip"));
		this.closeMenuItem.setMnemonic(this.resourceManager.getValue(
				"play.close.mnemonic").charAt(0));
		this.closeMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("play.close.keystroke")));
		// playMenu.add(closeMenuItem);
		if (this.play.isEmpty()) {
			this.closeMenuItem.setEnabled(false);
		}

		this.saveMenuItem = new JMenuItem();
		this.saveMenuItem.setText(this.resourceManager
				.getValue("play.save.text"));
		this.saveMenuItem.setToolTipText(this.resourceManager
				.getValue("play.save.tooltip"));
		this.saveMenuItem.setMnemonic(this.resourceManager.getValue(
				"play.save.mnemonic").charAt(0));
		this.saveMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("play.save.keystroke")));
		this.saveMenuItem.addActionListener(new SavePlayListener());
		// this.playMenu.add(this.saveMenuItem);
		if (this.play.isEmpty()) {
			this.saveMenuItem.setEnabled(false);
		}

		this.saveAsMenuItem = new JMenuItem();
		this.saveAsMenuItem.setText(this.resourceManager
				.getValue("play.saveas.text"));
		this.saveAsMenuItem.setToolTipText(this.resourceManager
				.getValue("play.saveas.tooltip"));
		this.saveAsMenuItem.setMnemonic(this.resourceManager.getValue(
				"play.saveas.mnemonic").charAt(0));
		// saveAsMenuItem.addActionListener(new SaveAsListener());
		// playMenu.add(saveAsMenuItem);
		if (this.play.isEmpty()) {
			this.saveAsMenuItem.setEnabled(false);
		}

		this.generateMenuItem = new JMenuItem();
		this.generateMenuItem.setText(this.resourceManager
				.getValue("play.generate.text"));
		this.generateMenuItem.setToolTipText(this.resourceManager
				.getValue("play.generate.tooltip"));
		this.generateMenuItem.setMnemonic(this.resourceManager.getValue(
				"play.generate.mnemonic").charAt(0));
		this.generateMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("play.generate.keystroke")));
		this.generateMenuItem.addActionListener(new GenerateListener(this));
		this.playMenu.add(this.generateMenuItem);
		if (this.play.isEmpty()) {
			this.generateMenuItem.setEnabled(false);
		}

		this.playMenu.addSeparator();

		this.actionMenuItem = new JMenuItem();
		this.actionMenuItem.setText(this.resourceManager
				.getValue("play.action.text"));
		this.actionMenuItem.setToolTipText(this.resourceManager
				.getValue("play.action.tooltip"));
		this.actionMenuItem.setMnemonic(this.resourceManager.getValue(
				"play.action.mnemonic").charAt(0));
		this.actionMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("play.action.keystroke")));
		this.actionMenuItem
				.addActionListener(new NewActionButtonListener(this));
		this.playMenu.add(this.actionMenuItem);
		if (this.play.isEmpty()) {
			this.actionMenuItem.setEnabled(false);
		}

		this.playMenu.addSeparator();

		this.quitMenuItem = new JMenuItem();
		this.quitMenuItem.setText(this.resourceManager
				.getValue("play.quit.text"));
		this.quitMenuItem.setToolTipText(this.resourceManager
				.getValue("play.quit.tooltip"));
		this.quitMenuItem.setMnemonic(this.resourceManager.getValue(
				"play.quit.mnemonic").charAt(0));
		this.quitMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("play.quit.keystroke")));
		this.quitMenuItem.addActionListener(new QuitListener());
		this.playMenu.add(this.quitMenuItem);
	}

	protected void initProgramMenu() {
		this.compileItem = new JMenuItem();
		this.compileItem.setText(this.resourceManager
				.getValue("program.compile.text"));
		this.compileItem.setToolTipText(this.resourceManager
				.getValue("program.compile.tooltip"));
		this.compileItem.setMnemonic(this.resourceManager.getValue(
				"program.compile.mnemonic").charAt(0));
		this.compileItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("program.compile.keystroke")));
		this.compileItem.addActionListener(CompileManager.getCompileManager());
		this.programMenu.add(this.compileItem);

		this.programSaveMenuItem = new JMenuItem();
		this.programSaveMenuItem.setText(this.resourceManager
				.getValue("program.save.text"));
		this.programSaveMenuItem.setToolTipText(this.resourceManager
				.getValue("program.save.tooltip"));
		this.programSaveMenuItem.setMnemonic(this.resourceManager.getValue(
				"program.save.mnemonic").charAt(0));
		this.programSaveMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("program.save.keystroke")));
		this.programSaveMenuItem.addActionListener(new SaveProgramListener());
		this.programMenu.add(this.programSaveMenuItem);

		this.programLoadMenuItem = new JMenuItem();
		this.programLoadMenuItem.setText(this.resourceManager
				.getValue("program.load.text"));
		this.programLoadMenuItem.setToolTipText(this.resourceManager
				.getValue("program.load.tooltip"));
		this.programLoadMenuItem.setMnemonic(this.resourceManager.getValue(
				"program.load.mnemonic").charAt(0));
		this.programLoadMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("program.load.keystroke")));
		this.programLoadMenuItem.addActionListener(new LoadProgramListener());
		this.programMenu.add(this.programLoadMenuItem);

		this.printMenuItem = this.solistEditor.getEditor().getPrintMenuItem();
		this.programMenu.add(this.printMenuItem);

		this.programMenu.addSeparator();

		this.undoMenuItem = this.solistEditor.getEditor().getUndoMenueItem();
		this.programMenu.add(this.undoMenuItem);

		this.redoMenuItem = this.solistEditor.getEditor().getRedoMenueItem();
		this.programMenu.add(this.redoMenuItem);

		this.programMenu.addSeparator();

		this.cutMenuItem = this.solistEditor.getEditor().getCutMenuItem();
		this.programMenu.add(this.cutMenuItem);

		this.copyMenuItem = this.solistEditor.getEditor().getCopyMenuItem();
		this.programMenu.add(this.copyMenuItem);

		this.pasteMenuItem = this.solistEditor.getEditor().getPasteMenuItem();
		this.programMenu.add(this.pasteMenuItem);

		this.programMenu.addSeparator();

		this.indentMenuItem = this.solistEditor.getEditor().getIndentMenuItem();
		this.programMenu.add(this.indentMenuItem);

		this.fontsizeMenu = this.solistEditor.getEditor().getFontsizeMenu();
		this.programMenu.add(this.fontsizeMenu);

		this.paradigmaMenuItem = new JCheckBoxMenuItem();
		this.paradigmaMenuItem.setSelected(Play.getPlay()
				.isImperativeParadigma());
		this.paradigmaMenuItem.setText(this.resourceManager
				.getValue("editor.paradigma.text"));
		this.paradigmaMenuItem.setToolTipText(this.resourceManager
				.getValue("editor.paradigma.tooltip"));
		this.paradigmaMenuItem.setMnemonic(this.resourceManager.getValue(
				"editor.paradigma.mnemonic").charAt(0));
		this.paradigmaMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("editor.paradigma.keystroke")));
		this.paradigmaMenuItem.addActionListener(new ParadigmaListener(this,
				this.paradigmaMenuItem));
		if (!this.play.isSimulator()) {
			this.programMenu.addSeparator();
			this.programMenu.add(this.paradigmaMenuItem);
		}

		if (this.play.isSimulator()) {
			this.programMenu.addSeparator();
			this.programMenu.add(this.quitMenuItem);
		}
	}

	protected void initStageMenu() {
		this.stageSaveMenuItem = new JMenuItem();
		this.stageSaveMenuItem.setText(this.resourceManager
				.getValue("stage.save.text"));
		this.stageSaveMenuItem.setToolTipText(this.resourceManager
				.getValue("stage.save.tooltip"));
		this.stageSaveMenuItem.setMnemonic(this.resourceManager.getValue(
				"stage.save.mnemonic").charAt(0));
		this.stageSaveMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("stage.save.keystroke")));
		this.stageSaveMenuItem.addActionListener(new SaveStageListener());
		this.stageMenu.add(this.stageSaveMenuItem);

		this.stageLoadMenuItem = new JMenuItem();
		this.stageLoadMenuItem.setText(this.resourceManager
				.getValue("stage.load.text"));
		this.stageLoadMenuItem.setToolTipText(this.resourceManager
				.getValue("stage.load.tooltip"));
		this.stageLoadMenuItem.setMnemonic(this.resourceManager.getValue(
				"stage.load.mnemonic").charAt(0));
		this.stageLoadMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("stage.load.keystroke")));
		this.stageLoadMenuItem.addActionListener(new LoadStageListener());
		this.stageMenu.add(this.stageLoadMenuItem);

		this.stageImageSaveMenu = new JMenu();
		this.stageImageSaveMenu.setText(this.resourceManager
				.getValue("stage.imagesave.text"));
		this.stageImageSaveMenu.setMnemonic(this.resourceManager.getValue(
				"stage.imagesave.mnemonic").charAt(0));

		this.stagePngSaveMenuItem = new JMenuItem();
		this.stagePngSaveMenuItem.setText(this.resourceManager
				.getValue("stage.pngsave.text"));
		this.stagePngSaveMenuItem.setToolTipText(this.resourceManager
				.getValue("stage.pngsave.tooltip"));
		this.stagePngSaveMenuItem.setMnemonic(this.resourceManager.getValue(
				"stage.pngsave.mnemonic").charAt(0));
		this.stagePngSaveMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("stage.pngsave.keystroke")));
		this.stagePngSaveMenuItem
				.addActionListener(new SaveStageAsPngListener());
		this.stageImageSaveMenu.add(this.stagePngSaveMenuItem);

		this.stageGifSaveMenuItem = new JMenuItem();
		this.stageGifSaveMenuItem.setText(this.resourceManager
				.getValue("stage.gifsave.text"));
		this.stageGifSaveMenuItem.setToolTipText(this.resourceManager
				.getValue("stage.gifsave.tooltip"));
		this.stageGifSaveMenuItem.setMnemonic(this.resourceManager.getValue(
				"stage.gifsave.mnemonic").charAt(0));
		this.stageGifSaveMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("stage.gifsave.keystroke")));
		this.stageGifSaveMenuItem
				.addActionListener(new SaveStageAsGifListener());
		this.stageImageSaveMenu.add(this.stageGifSaveMenuItem);

		this.stageJpgSaveMenuItem = new JMenuItem();
		this.stageJpgSaveMenuItem.setText(this.resourceManager
				.getValue("stage.jpgsave.text"));
		this.stageJpgSaveMenuItem.setToolTipText(this.resourceManager
				.getValue("stage.jpgsave.tooltip"));
		this.stageJpgSaveMenuItem.setMnemonic(this.resourceManager.getValue(
				"stage.jpgsave.mnemonic").charAt(0));
		this.stageJpgSaveMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("stage.jpgsave.keystroke")));
		this.stageJpgSaveMenuItem
				.addActionListener(new SaveStageAsJpgListener());
		// this.stageImageSaveMenu.add(this.stageJpgSaveMenuItem); todo: Fehler

		this.stageMenu.add(this.stageImageSaveMenu);
	}

	protected void initMediaMenu() {
		this.imagesMenuItem = new JMenuItem();
		this.imagesMenuItem.setText(this.resourceManager
				.getValue("media.images.text"));
		this.imagesMenuItem.setToolTipText(this.resourceManager
				.getValue("media.images.tooltip"));
		this.imagesMenuItem.setMnemonic(this.resourceManager.getValue(
				"media.images.mnemonic").charAt(0));
		this.imagesMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("media.images.keystroke")));
		this.imagesMenuItem.addActionListener(new LoadImageListener());
		this.mediaMenu.add(this.imagesMenuItem);

		this.audioMenuItem = new JMenuItem();
		this.audioMenuItem.setText(this.resourceManager
				.getValue("media.audio.text"));
		this.audioMenuItem.setToolTipText(this.resourceManager
				.getValue("media.audio.tooltip"));
		this.audioMenuItem.setMnemonic(this.resourceManager.getValue(
				"media.audio.mnemonic").charAt(0));
		this.audioMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("media.audio.keystroke")));
		this.audioMenuItem.addActionListener(new LoadSoundListener());
		this.mediaMenu.add(this.audioMenuItem);
	}

	protected void initHelpMenu() {
		this.manualMenuItem = new JMenuItem();
		this.manualMenuItem.setText(this.resourceManager
				.getValue("help.manual.text"));
		this.manualMenuItem.setToolTipText(this.resourceManager
				.getValue("help.manual.tooltip"));
		this.manualMenuItem.setMnemonic(this.resourceManager.getValue(
				"help.manual.mnemonic").charAt(0));

		this.manualMenuItem.setAccelerator(KeyStroke.getKeyStroke(
				KeyEvent.VK_F1, 0));

		this.manualMenuItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				try {
					Desktop desktop = Desktop.getDesktop();
					desktop.browse(new File("handbuch/html/handbuch.htm").toURI());
				} catch (Throwable th) {
					th.printStackTrace();
				}
			}
		});
		this.helpMenu.add(this.manualMenuItem);
		
		this.pdfManualMenuItem = new JMenuItem();
		this.pdfManualMenuItem.setText(this.resourceManager
				.getValue("help.pdfmanual.text"));
		this.pdfManualMenuItem.setToolTipText(this.resourceManager
				.getValue("help.pdfmanual.tooltip"));
		this.pdfManualMenuItem.setMnemonic(this.resourceManager.getValue(
				"help.pdfmanual.mnemonic").charAt(0));
		this.pdfManualMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("help.pdfmanual.keystroke")));

		this.pdfManualMenuItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				try {
					Desktop desktop = Desktop.getDesktop();
					desktop.open(new File("handbuch/handbuch.pdf"));
				} catch (Throwable th) {
					th.printStackTrace();
				}
			}
		});
		this.helpMenu.add(this.pdfManualMenuItem);

		this.apiMenuItem = new JMenuItem();
		this.apiMenuItem
				.setText(this.resourceManager.getValue("help.api.text"));
		this.apiMenuItem.setToolTipText(this.resourceManager
				.getValue("help.api.tooltip"));
		this.apiMenuItem.setMnemonic(this.resourceManager.getValue(
				"help.api.mnemonic").charAt(0));
		this.apiMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("help.api.keystroke")));
		this.apiMenuItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				try {
					Desktop desktop = Desktop.getDesktop();
					desktop.browse(new File("api/index.html").toURI());
				} catch (Throwable th) {
					th.printStackTrace();
				}
			}
		});
		this.helpMenu.add(this.apiMenuItem);

		this.aboutMenuItem = new JMenuItem();
		this.aboutMenuItem.setText(this.resourceManager
				.getValue("help.about.text"));
		this.aboutMenuItem.setToolTipText(this.resourceManager
				.getValue("help.about.tooltip"));
		this.aboutMenuItem.setMnemonic(this.resourceManager.getValue(
				"help.about.mnemonic").charAt(0));
		this.aboutMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("help.about.keystroke")));
		this.aboutMenuItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				JOptionPane.showMessageDialog(PlayFrame.this,
						PlayFrame.this.resourceManager.getValue("info.text"),
						PlayFrame.this.resourceManager.getValue("info.title"),
						JOptionPane.PLAIN_MESSAGE);
			}
		});
		this.helpMenu.add(this.aboutMenuItem);
	}

	protected void initSimulatorHelpMenu() {

		if (PropertyManager.getPropertyManager().getHandbookOnline() != null) {
			this.handbookOnlineMenuItem = new JMenuItem();
			this.handbookOnlineMenuItem.setText(this.resourceManager
					.getValue("help.genhandbookonline.text"));
			this.handbookOnlineMenuItem.setToolTipText(this.resourceManager
					.getValue("help.genhandbookonline.tooltip"));
			this.handbookOnlineMenuItem.setMnemonic(this.resourceManager
					.getValue("help.genhandbookonline.mnemonic").charAt(0));
			this.handbookOnlineMenuItem.setAccelerator(KeyStroke
					.getKeyStroke(this.resourceManager
							.getValue("help.genhandbookonline.keystroke")));
			this.handbookOnlineMenuItem.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					try {
						Desktop desktop = Desktop.getDesktop();
						desktop.browse(new URI(PropertyManager
								.getPropertyManager().getHandbookOnline()));
					} catch (Throwable th) {
						th.printStackTrace();
					}
				}
			});
			this.helpMenu.add(this.handbookOnlineMenuItem);
		}

		if (PropertyManager.getPropertyManager().getHandbookOffline() != null) {
			this.handbookOfflineMenuItem = new JMenuItem();
			this.handbookOfflineMenuItem.setText(this.resourceManager
					.getValue("help.genhandbookoffline.text"));
			this.handbookOfflineMenuItem.setToolTipText(this.resourceManager
					.getValue("help.genhandbookoffline.tooltip"));
			this.handbookOfflineMenuItem.setMnemonic(this.resourceManager
					.getValue("help.genhandbookoffline.mnemonic").charAt(0));
			this.handbookOfflineMenuItem.setAccelerator(KeyStroke
					.getKeyStroke(this.resourceManager
							.getValue("help.genhandbookoffline.keystroke")));
			this.handbookOfflineMenuItem
					.addActionListener(new ActionListener() {
						public void actionPerformed(ActionEvent e) {
							try {
								Desktop desktop = Desktop.getDesktop();
								desktop.open(new File(PropertyManager
										.getPropertyManager()
										.getHandbookOffline()));
							} catch (Throwable th) {
								th.printStackTrace();
							}
						}
					});
			this.helpMenu.add(this.handbookOfflineMenuItem);
		}

		if (PropertyManager.getPropertyManager().getHandbookOffline() != null
				|| PropertyManager.getPropertyManager().getHandbookOnline() != null) {
			this.helpMenu.addSeparator();
		}

		this.genAboutMenuItem = new JMenuItem();
		this.genAboutMenuItem.setText(this.resourceManager
				.getValue("help.genabout.text")
				+ " " + this.play.getGenName());
		this.genAboutMenuItem.setToolTipText(this.resourceManager
				.getValue("help.genabout.tooltip")
				+ " " + this.play.getGenName());
		this.genAboutMenuItem.setMnemonic(this.resourceManager.getValue(
				"help.genabout.mnemonic").charAt(0));
		this.genAboutMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("help.genabout.keystroke")));
		this.genAboutMenuItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				InfoFrame.getInstance().setVisible(true);
			}
		});
		this.helpMenu.add(this.genAboutMenuItem);
	}

	protected void initControlsMenu() {
		this.runMenuItem = new JMenuItem();
		this.runMenuItem.setText(this.resourceManager
				.getValue("controls.run.text"));
		this.runMenuItem.setToolTipText(this.resourceManager
				.getValue("controls.run.tooltip"));
		this.runMenuItem.setMnemonic(this.resourceManager.getValue(
				"controls.run.mnemonic").charAt(0));
		this.runMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("controls.run.keystroke")));
		if (this.play.isEmpty()) {
			this.runMenuItem.setEnabled(false);
		}
		if (CompileManager.getCompileManager().isCompilationRequired()) {
			this.runMenuItem.setEnabled(false);
		}
		this.controlsMenu.add(this.runMenuItem);

		this.stepMenuItem = new JMenuItem();
		this.stepMenuItem.setText(this.resourceManager
				.getValue("controls.step.text"));
		this.stepMenuItem.setToolTipText(this.resourceManager
				.getValue("controls.step.tooltip"));
		this.stepMenuItem.setMnemonic(this.resourceManager.getValue(
				"controls.step.mnemonic").charAt(0));
		this.stepMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("controls.step.keystroke")));
		if (this.play.isEmpty()) {
			this.stepMenuItem.setEnabled(false);
		}
		if (PropertyManager.getPropertyManager().isDebuggingOn()) {
			this.controlsMenu.add(this.stepMenuItem);
		}

		this.pauseMenuItem = new JMenuItem();
		this.pauseMenuItem.setText(this.resourceManager
				.getValue("controls.pause.text"));
		this.pauseMenuItem.setToolTipText(this.resourceManager
				.getValue("controls.pause.tooltip"));
		this.pauseMenuItem.setMnemonic(this.resourceManager.getValue(
				"controls.pause.mnemonic").charAt(0));
		this.pauseMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("controls.pause.keystroke")));
		if (this.play.isEmpty()) {
			this.pauseMenuItem.setEnabled(false);
		}
		this.controlsMenu.add(this.pauseMenuItem);

		this.stopMenuItem = new JMenuItem();
		this.stopMenuItem.setEnabled(false);
		this.stopMenuItem.setText(this.resourceManager
				.getValue("controls.stop.text"));
		this.stopMenuItem.setToolTipText(this.resourceManager
				.getValue("controls.stop.tooltip"));
		this.stopMenuItem.setMnemonic(this.resourceManager.getValue(
				"controls.stop.mnemonic").charAt(0));
		this.stopMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("controls.stop.keystroke")));
		if (this.play.isEmpty()) {
			this.stopMenuItem.setEnabled(false);
		}
		this.controlsMenu.add(this.stopMenuItem);

		this.controlsMenu.addSeparator();

		this.backMenuItem = new JMenuItem();
		this.backMenuItem.setText(this.resourceManager
				.getValue("controls.back.text"));
		this.backMenuItem.setToolTipText(this.resourceManager
				.getValue("controls.back.tooltip"));
		this.backMenuItem.setMnemonic(this.resourceManager.getValue(
				"controls.back.mnemonic").charAt(0));
		this.backMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("controls.back.keystroke")));
		if (this.play.isEmpty()) {
			this.backMenuItem.setEnabled(false);
		}
		if (CompileManager.getCompileManager().isCompilationRequired()) {
			this.backMenuItem.setEnabled(false);
		}
		this.controlsMenu.add(this.backMenuItem);

		this.resetMenuItem = new JMenuItem();
		this.resetMenuItem.setText(this.resourceManager
				.getValue("controls.reset.text"));
		this.resetMenuItem.setToolTipText(this.resourceManager
				.getValue("controls.reset.tooltip"));
		this.resetMenuItem.setMnemonic(this.resourceManager.getValue(
				"controls.reset.mnemonic").charAt(0));
		this.resetMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("controls.reset.keystroke")));
		if (this.play.isEmpty()) {
			this.resetMenuItem.setEnabled(false);
		}
		if (CompileManager.getCompileManager().isCompilationRequired()) {
			this.resetMenuItem.setEnabled(false);
		}
		this.controlsMenu.add(this.resetMenuItem);

		this.controlsMenu.addSeparator();

		this.debugMenuItem = new JCheckBoxMenuItem();
		this.debugMenuItem.setSelected(false);
		this.debugMenuItem.setText(this.resourceManager
				.getValue("controls.debug.text"));
		this.debugMenuItem.setToolTipText(this.resourceManager
				.getValue("controls.debug.tooltip"));
		this.debugMenuItem.setMnemonic(this.resourceManager.getValue(
				"controls.debug.mnemonic").charAt(0));
		this.debugMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("controls.debug.keystroke")));
		this.debugMenuItem.addActionListener(new DebuggerListener(
				this.debugMenuItem));
		if (this.play.isEmpty()) {
			this.debugMenuItem.setEnabled(false);
		}
		if (PropertyManager.getPropertyManager().isDebuggingOn()) {
			this.controlsMenu.add(this.debugMenuItem);
		}

	}

	protected void initWindowMenu() {
		this.consoleMenuItem = new JCheckBoxMenuItem();
		this.consoleMenuItem.setText(this.resourceManager
				.getValue("window.console.text"));
		this.consoleMenuItem.setToolTipText(this.resourceManager
				.getValue("window.console.tooltip"));
		this.consoleMenuItem.setMnemonic(this.resourceManager.getValue(
				"window.console.mnemonic").charAt(0));
		this.consoleMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("window.console.keystroke")));
		this.consoleMenuItem.addActionListener(new WindowVisible(Console
				.getConsole(), this.consoleMenuItem));
		if (this.play.isEmpty()) {
			this.consoleMenuItem.setEnabled(false);
		}
		this.windowMenu.add(this.consoleMenuItem);

		this.iFrameMenuItem = new JCheckBoxMenuItem();
		this.iFrameMenuItem.setText(this.resourceManager
				.getValue("window.iframe.text"));
		this.iFrameMenuItem.setToolTipText(this.resourceManager
				.getValue("window.iframe.tooltip"));
		this.iFrameMenuItem.setMnemonic(this.resourceManager.getValue(
				"window.iframe.mnemonic").charAt(0));
		this.iFrameMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("window.iframe.keystroke")));
		this.iFrameMenuItem.addActionListener(new IFrameVisible(
				InstructionFrame.getInstructionFrame(), this.iFrameMenuItem));
		if (this.play.isEmpty()) {
			this.iFrameMenuItem.setEnabled(false);
		}
		this.windowMenu.add(this.iFrameMenuItem);

		this.debuggerFrameMenuItem = new JCheckBoxMenuItem();
		this.debuggerFrameMenuItem.setText(this.resourceManager
				.getValue("window.debuggerframe.text"));
		this.debuggerFrameMenuItem.setToolTipText(this.resourceManager
				.getValue("window.debuggerframe.tooltip"));
		this.debuggerFrameMenuItem.setMnemonic(this.resourceManager.getValue(
				"window.debuggerframe.mnemonic").charAt(0));
		this.debuggerFrameMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("window.debuggerframe.keystroke")));
		this.debuggerFrameMenuItem.addActionListener(new WindowVisible(
				DebuggerFrame.getDebuggerFrame(), this.debuggerFrameMenuItem));
		if (this.play.isEmpty()) {
			this.debuggerFrameMenuItem.setEnabled(false);
		}
		if (PropertyManager.getPropertyManager().isDebuggingOn()) {
			this.windowMenu.add(this.debuggerFrameMenuItem);
		}
	}

	public void switchRunResume(boolean setRun) {
		if (setRun) {
			this.runMenuItem.setText(this.resourceManager
					.getValue("controls.run.text"));
			this.runMenuItem.setToolTipText(this.resourceManager
					.getValue("controls.run.tooltip"));
			this.runMenuItem.setMnemonic(this.resourceManager.getValue(
					"controls.run.mnemonic").charAt(0));
			this.runButton.setToolTipText(this.resourceManager
					.getValue("play.toolbar.run"));
		} else {
			this.runMenuItem.setText(this.resourceManager
					.getValue("controls.run.text2"));
			this.runMenuItem.setToolTipText(this.resourceManager
					.getValue("controls.run.tooltip2"));
			this.runMenuItem.setMnemonic(this.resourceManager.getValue(
					"controls.run.mnemonic2").charAt(0));
			this.runButton.setToolTipText(this.resourceManager
					.getValue("play.toolbar.run2"));
		}
	}

	protected void createOpenRecentSubMenu() {
		this.openRecentSubMenu = new JMenu();
		this.openRecentSubMenu.setText(this.resourceManager
				.getValue("play.openrecent.text"));

		this.recent1 = new JMenuItem();
		this.recent1.setText("Recent 1");
		this.openRecentSubMenu.add(this.recent1);

		this.recent2 = new JMenuItem();
		this.recent2.setText("Recent 2");
		this.openRecentSubMenu.add(this.recent2);
	}

	protected void initToolBar() {
		this.toolBar = new JToolBar();
		this.toolBar.setBackground(new Color(255, 215, 180));

		if (!this.play.isSimulator()) {
			this.newButton = new JButton(ResourceLoader
					.getImageIcon("New24.gif"));
			this.newButton.setToolTipText(this.resourceManager
					.getValue("play.toolbar.new"));
			this.newButton.setMargin(new Insets(0, 0, 0, 0));
			this.newButton.addActionListener(NewPlayListener
					.getNewPlayManager());
			this.toolBar.add(this.newButton);

			this.openButton = new JButton(ResourceLoader
					.getImageIcon("Open24.gif"));
			this.openButton.setToolTipText(this.resourceManager
					.getValue("play.toolbar.open"));
			this.openButton.setMargin(new Insets(0, 0, 0, 0));
			this.openButton.addActionListener(OpenPlayListener
					.getOpenPlayManager());
			this.toolBar.add(Box.createRigidArea(new Dimension(2, 2)));
			this.toolBar.add(this.openButton);

			this.saveButton = new JButton(ResourceLoader
					.getImageIcon("Save24.gif"));
			this.saveButton.setToolTipText(this.resourceManager
					.getValue("play.toolbar.save"));
			this.saveButton.setMargin(new Insets(0, 0, 0, 0));
			this.saveButton.addActionListener(new SavePlayListener());
			this.toolBar.add(Box.createRigidArea(new Dimension(2, 2)));
			// this.toolBar.add(this.saveButton);
			if (this.play.isEmpty()) {
				this.saveButton.setEnabled(false);
			}

			this.toolBar.add(Box.createRigidArea(new Dimension(11, 11)));
		}

		this.compileButton = new JButton(ResourceLoader
				.getImageIcon("Compile24.gif"));
		this.compileBackgroundColor = this.compileButton.getBackground();
		this.setCompiled(!CompileManager.getCompileManager()
				.isCompilationRequired());
		this.compileButton.setToolTipText(this.resourceManager
				.getValue("play.toolbar.compile"));
		this.compileButton.setMargin(new Insets(0, 0, 0, 0));
		this.compileButton
				.addActionListener(CompileManager.getCompileManager());
		this.toolBar.add(this.compileButton);
		if (this.play.isEmpty()) {
			this.compileButton.setEnabled(false);
		}

		this.infoButton = new JButton(ResourceLoader
				.getImageIcon("Information24.gif"));
		this.infoButton.setToolTipText(this.resourceManager
				.getValue("play.toolbar.info"));
		this.infoButton.setMargin(new Insets(0, 0, 0, 0));
		this.toolBar.add(Box.createRigidArea(new Dimension(2, 2)));
		this.infoButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				Editor editor = PlayFrame.this.play.getInfoEditor();
				if (!editor.isOpen()) {
					Point p = ((JComponent) e.getSource())
							.getLocationOnScreen();
					editor.setLocation(Math
							.max(20, p.x - editor.getWidth() / 2), Math.max(20,
							p.y - editor.getHeight() / 2));
					editor.open();
				}
				editor.toFront();
			}
		});
		this.toolBar.add(this.infoButton);
		if (this.play.isEmpty()) {
			this.infoButton.setEnabled(false);
		}

		this.toolBar.add(Box.createRigidArea(new Dimension(11, 11)));

		this.initEditorButtons();

		this.toolBar.add(Box.createRigidArea(new Dimension(11, 11)));

		if (!this.play.isSimulator()) {
			this.initSimulationButtons();
			this.toolBar.add(Box.createRigidArea(new Dimension(11, 11)));
			this.addActionButtonsToToolbar();
		} else {
			this.addActionButtonsToToolbar();
			this.toolBar.add(Box.createRigidArea(new Dimension(11, 11)));
			this.initSimulationButtons();
		}

		this.add(this.toolBar, java.awt.BorderLayout.NORTH);
	}

	private void initEditorButtons() {
		this.printButton = this.solistEditor.getEditor().getPrintButton();
		this.printButton.setMargin(new Insets(0, 0, 0, 0));
		this.toolBar.add(this.printButton);

		this.toolBar.add(Box.createRigidArea(new Dimension(11, 11)));

		this.cutButton = this.solistEditor.getEditor().getCutButton();
		this.cutButton.setMargin(new Insets(0, 0, 0, 0));
		this.toolBar.add(this.cutButton);
		this.toolBar.add(Box.createRigidArea(new Dimension(2, 2)));

		this.copyButton = this.solistEditor.getEditor().getCopyButton();
		this.copyButton.setMargin(new Insets(0, 0, 0, 0));
		this.toolBar.add(this.copyButton);
		this.toolBar.add(Box.createRigidArea(new Dimension(2, 2)));

		this.pasteButton = this.solistEditor.getEditor().getPasteButton();
		this.pasteButton.setMargin(new Insets(0, 0, 0, 0));
		this.toolBar.add(this.pasteButton);
		this.toolBar.add(Box.createRigidArea(new Dimension(11, 11)));

		this.undoButton = this.solistEditor.getEditor().getUndoButton();
		this.undoButton.setMargin(new Insets(0, 0, 0, 0));
		this.toolBar.add(this.undoButton);
		this.toolBar.add(Box.createRigidArea(new Dimension(2, 2)));

		this.redoButton = this.solistEditor.getEditor().getRedoButton();
		this.redoButton.setMargin(new Insets(0, 0, 0, 0));
		this.toolBar.add(this.redoButton);

		if (this.play.isEmpty()) {
			this.printButton.setEnabled(false);
			this.cutButton.setEnabled(false);
			this.copyButton.setEnabled(false);
			this.pasteButton.setEnabled(false);
			this.undoButton.setEnabled(false);
			this.redoButton.setEnabled(false);
		}
	}

	private void initSimulationButtons() {
		this.runButton = new JButton(ResourceLoader.getImageIcon("Run24.gif"));
		this.runButton.setToolTipText(this.resourceManager
				.getValue("play.toolbar.run"));
		this.runButton.setMargin(new Insets(0, 0, 0, 0));
		this.toolBar.add(this.runButton);
		if (this.play.isEmpty()) {
			this.runButton.setEnabled(false);
		} else if (CompileManager.getCompileManager().isCompilationRequired()) {
			this.runButton.setEnabled(false);
		}

		this.stepButton = new JButton(ResourceLoader.getImageIcon("Step24.gif"));
		this.stepButton.setToolTipText(this.resourceManager
				.getValue("play.toolbar.step"));
		this.stepButton.setMargin(new Insets(0, 0, 0, 0));
		this.toolBar.add(Box.createRigidArea(new Dimension(2, 2)));
		if (PropertyManager.getPropertyManager().isDebuggingOn()) {
			this.toolBar.add(this.stepButton);
		}
		if (this.play.isEmpty()) {
			this.stepButton.setEnabled(false);
		}

		this.pauseButton = new JButton(ResourceLoader
				.getImageIcon("Pause24.gif"));
		this.pauseButton.setToolTipText(this.resourceManager
				.getValue("play.toolbar.pause"));
		this.pauseButton.setMargin(new Insets(0, 0, 0, 0));
		this.toolBar.add(this.pauseButton);
		if (this.play.isEmpty()) {
			this.pauseButton.setEnabled(false);
		}

		this.stopButton = new JButton(ResourceLoader.getImageIcon("Stop24.gif"));
		this.stopButton.setEnabled(false);
		this.stopButton.setToolTipText(this.resourceManager
				.getValue("play.toolbar.stop"));
		this.stopButton.setMargin(new Insets(0, 0, 0, 0));
		this.toolBar.add(Box.createRigidArea(new Dimension(2, 2)));
		this.toolBar.add(this.stopButton);
		if (this.play.isEmpty()) {
			this.stopButton.setEnabled(false);
		}

		this.backButton = new JButton(ResourceLoader.getImageIcon("Back24.gif"));
		this.backButton.setToolTipText(this.resourceManager
				.getValue("play.toolbar.back"));
		this.backButton.setMargin(new Insets(0, 0, 0, 0));
		// this.resetButton.addActionListener(new ResetListener());
		this.toolBar.add(Box.createRigidArea(new Dimension(11, 11)));
		this.toolBar.add(this.backButton);
		if (this.play.isEmpty()) {
			this.backButton.setEnabled(false);
		} else if (CompileManager.getCompileManager().isCompilationRequired()) {
			this.backButton.setEnabled(false);
		}

		this.resetButton = new JButton(ResourceLoader
				.getImageIcon("StepBack24.gif"));
		this.resetButton.setToolTipText(this.resourceManager
				.getValue("play.toolbar.reset"));
		this.resetButton.setMargin(new Insets(0, 0, 0, 0));
		this.toolBar.add(Box.createRigidArea(new Dimension(2, 2)));
		this.toolBar.add(this.resetButton);
		if (this.play.isEmpty()) {
			this.resetButton.setEnabled(false);
		} else if (CompileManager.getCompileManager().isCompilationRequired()) {
			this.resetButton.setEnabled(false);
		}

		this.debuggerButton = new JToggleButton(ResourceLoader
				.getImageIcon("Debugger24.gif"));
		this.debuggerButton.setToolTipText(this.resourceManager
				.getValue("play.toolbar.debuggerOn"));
		this.debuggerButton.setMargin(new Insets(0, 0, 0, 0));
		this.debuggerButton.addActionListener(new DebuggerListener(
				this.debuggerButton));
		this.toolBar.add(Box.createRigidArea(new Dimension(11, 11)));
		if (PropertyManager.getPropertyManager().isDebuggingOn()) {
			this.toolBar.add(this.debuggerButton);
		}
		if (this.play.isEmpty()) {
			this.debuggerButton.setEnabled(false);
		}

		this.speedSlider = new JSlider(SwingConstants.HORIZONTAL,
				Performance.MIN_SPEED, Performance.MAX_SPEED, this.play
						.getActivePerformance().getSimulationSpeed());
		this.speedSlider.setBackground(this.toolBar.getBackground());
		this.speedSlider.setToolTipText(this.resourceManager
				.getValue("play.toolbar.speed"));
		this.speedSlider.setMajorTickSpacing(50);
		this.speedSlider.setMinorTickSpacing(25);
		this.speedSlider.setPaintTicks(true);
		this.speedSlider.setPaintLabels(false);
		this.speedSlider.setSnapToTicks(false);
		this.speedSlider.setMaximumSize(new Dimension(200, 50));
		this.speedSlider.setMinimumSize(new Dimension(100, 50));
		this.speedSlider.addChangeListener(new SpeedListener(this.speedSlider));
		this.toolBar.add(Box.createRigidArea(new Dimension(11, 11)));
		this.toolBar.add(this.speedSlider);
		if (this.play.isEmpty()) {
			this.speedSlider.setEnabled(false);
		}
	}

	public void addActionButtonsToToolbar() {
		for (String className : this.play.getActionButtonClasses()) {
			ActionButtonClass cls = (ActionButtonClass) ClassManager
					.getClassManager().getClass(className);
			this.addActionButtonToToolbar(cls.getActionButton(), false);
		}
		this.toolBar.validate();
		this.toolBar.repaint();
	}

	public void removeActionButtonsFromToolbar() {
		for (String className : this.play.getActionButtonClasses()) {
			ActionButtonClass cls = (ActionButtonClass) ClassManager
					.getClassManager().getClass(className);
			this.removeActionButtonFromToolbar(cls.getActionButton(), false);
		}
		this.toolBar.validate();
		this.toolBar.repaint();
	}

	public void repaintActionButtons() {
		this.removeActionButtonsFromToolbar();
		this.addActionButtonsToToolbar();
	}

	public void addActionButtonToToolbar(ActionButton button, boolean repaint) {
		AbstractButton newButton = button.getJButton();
		newButton.setToolTipText(button.getTooltip());
		newButton.setMargin(new Insets(0, 0, 0, 0));
		this.toolBar.add(newButton);
		if (repaint) {
			this.toolBar.validate();
			this.toolBar.repaint();
		}
	}

	public void removeActionButtonFromToolbar(ActionButton b, boolean repaint) {
		AbstractButton button = b.getJButton();
		this.toolBar.remove(button);
		if (repaint) {
			this.toolBar.validate();
			this.toolBar.repaint();
		}
	}

	public int getSpeed() {
		return this.speedSlider.getValue();
	}

	public void setSpeed(int newSpeed) {
		if (this.speedSlider.getValue() != newSpeed) {
			this.speedSlider.setValue(newSpeed);
		}
	}

	protected void initFileTree() {
		this.fileTreeSurrounding = new JPanel();
		this.fileTreeSurrounding.setLayout(new BorderLayout());
		this.fileTreeSurrounding.add(
				Box.createRigidArea(new Dimension(12, 12)), BorderLayout.NORTH);
		this.fileTreeSurrounding.add(
				Box.createRigidArea(new Dimension(12, 12)), BorderLayout.SOUTH);
		this.fileTreeSurrounding.add(
				Box.createRigidArea(new Dimension(12, 12)), BorderLayout.WEST);
		this.fileTreeSurrounding.add(
				Box.createRigidArea(new Dimension(12, 12)), BorderLayout.EAST);

		DefaultMutableTreeNode root = new DirectoryTreeNode(Play.CLASSES);
		DefaultMutableTreeNode worldNode = new DirectoryTreeNode(Play.STAGE);
		root.add(worldNode);
		for (String className : this.play.getStageClasses()) {
			DefaultMutableTreeNode cNode = new DefaultMutableTreeNode(className);
			worldNode.add(cNode);
		}

		DefaultMutableTreeNode actorNode = new DirectoryTreeNode(Play.ACTOR);
		root.add(actorNode);
		for (String className : this.play.getActorClasses()) {
			DefaultMutableTreeNode cNode = new DefaultMutableTreeNode(className);
			actorNode.add(cNode);
		}

		DefaultMutableTreeNode propNode = new DirectoryTreeNode(Play.PROP);
		root.add(propNode);
		for (String className : this.play.getPropClasses()) {
			DefaultMutableTreeNode cNode = new DefaultMutableTreeNode(className);
			propNode.add(cNode);
		}

		DefaultMutableTreeNode performanceNode = new DirectoryTreeNode(
				Play.PERFORMANCE);
		root.add(performanceNode);
		for (String className : this.play.getPerformanceClasses()) {
			DefaultMutableTreeNode cNode = new DefaultMutableTreeNode(className);
			performanceNode.add(cNode);
		}

		DefaultMutableTreeNode otherNode = new DirectoryTreeNode(Play.OTHER);
		root.add(otherNode);
		for (String className : this.play.getOtherClasses()) {
			DefaultMutableTreeNode cNode = new DefaultMutableTreeNode(className);
			otherNode.add(cNode);
		}

		DefaultTreeModel treeModel = new DefaultTreeModel(root);
		this.fileTree = new FileTree(treeModel);
		this.fileTree.setBackground(new Color(240, 252, 202));
		TreeSelectionModel tsm = new DefaultTreeSelectionModel();

		/*
		 * ImageIcon leafIcon =
		 * ResourcesLoader.getImageIcon("StartPicture.png"); if (leafIcon !=
		 * null) { DefaultTreeCellRenderer renderer = new
		 * DefaultTreeCellRenderer(); renderer.setLeafIcon(leafIcon);
		 * fileTree.setCellRenderer(renderer); }
		 */

		this.fileTree.setCellRenderer(new FileTreeCellRenderer());
		tsm.setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
		this.fileTree.setSelectionModel(tsm);
		this.fileTree.setRootVisible(true);
		this.fileTree.setBorder(BorderFactory.createEmptyBorder());
		if (this.play.isEmpty()) {
			this.fileTree.setEnabled(false);
		} else {
			this.dirPopupMenu = new DirectoryPopupMenu(this.fileTree);
			MouseListener popupListener = new FileTreePopupListener(
					this.dirPopupMenu, this.fileTree);
			this.fileTree.addMouseListener(popupListener);
		}

		this.fileTreeSurrounding.setBackground(this.fileTree.getBackground());
		this.fileTreeSurrounding.add(this.fileTree, BorderLayout.CENTER);

		Collection<TheaterClass> coll = ClassManager.getClassManager()
				.getAllClasses();
		for (TheaterClass cls : coll) {
			cls.getEditor().addObserver(this.fileTree);
		}
	}

	protected void initStage() {
		this.stage = new StagePanel(this.play);
	}

	protected void initMessagePanel() {
		if (play.isSimulator()) {
			this.messagePanel = new MessagePanel(ResourceManager
					.getResourceManager().getValue("msg.welcome")
					+ "!");
		} else {
			this.messagePanel = new MessagePanel(ResourceManager
					.getResourceManager().getValue("msg.welcome")
					+ " "
					+ ResourceManager.getResourceManager().getValue(
							"msg.welcome2") + " - " + Utils.getVersion());
		}
	}

	protected void handleSimulation() {
		this.simulationManager = new ActSimulationManager(this.runButton,
				this.pauseButton, this.stopButton, this.backButton,
				this.resetButton, this.stepButton, this.runMenuItem,
				this.pauseMenuItem, this.stopMenuItem, this.backMenuItem,
				this.resetMenuItem, this.stepMenuItem, this.debuggerButton,
				this.debugMenuItem);
		SimulationManager.setSimulationManager(this.simulationManager);
		this.runButton.addActionListener(this.simulationManager);
		this.pauseButton.addActionListener(this.simulationManager);
		this.stopButton.addActionListener(this.simulationManager);
		this.backButton.addActionListener(this.simulationManager);
		this.resetButton.addActionListener(this.simulationManager);
		this.stepButton.addActionListener(this.simulationManager);
		this.runMenuItem.addActionListener(this.simulationManager);
		this.pauseMenuItem.addActionListener(this.simulationManager);
		this.stopMenuItem.addActionListener(this.simulationManager);
		this.backMenuItem.addActionListener(this.simulationManager);
		this.resetMenuItem.addActionListener(this.simulationManager);
		this.stepMenuItem.addActionListener(this.simulationManager);

		if (this.play.isEmpty()) {
			this.runButton.setEnabled(false);
			this.stopButton.setEnabled(false);
			this.backButton.setEnabled(false);
			this.resetButton.setEnabled(false);
			this.stepButton.setEnabled(false);
			this.debuggerButton.setEnabled(false);
			this.runMenuItem.setEnabled(false);
			this.stopMenuItem.setEnabled(false);
			this.backMenuItem.setEnabled(false);
			this.resetMenuItem.setEnabled(false);
			this.stepMenuItem.setEnabled(false);
			this.debugMenuItem.setEnabled(false);
		}
	}

	public void setCompiled(boolean state) {
		this.compiled = state;
		if (this.compiled) {
			this.compileButton.setBackground(this.compileBackgroundColor);
		} else {
			this.compileButton.setBackground(new Color(255, 100, 100));
		}
	}

	public void windowActivated(WindowEvent e) {

	}

	public void windowClosed(WindowEvent e) {
		// new QuitListener().quit();
	}

	public void windowClosing(WindowEvent e) {
		QuitListener.quit();
	}

	public void windowDeactivated(WindowEvent e) {

	}

	public void windowDeiconified(WindowEvent e) {

	}

	public void windowIconified(WindowEvent e) {

	}

	public void windowOpened(WindowEvent e) {

	}

	public void update(Observable o, Object arg) {
		boolean required = CompileManager.getCompileManager()
				.isCompilationRequired();
		this.setCompiled(!required);
		if (required) {
			this.generateMenuItem.setEnabled(false);
		} else {
			this.generateMenuItem.setEnabled(true);
		}
	}

	public JSplitPane getSolistEditorSplitPane() {
		return this.solistEditorSplitPane;
	}

	public SolistEditor getSolistEditor() {
		return this.solistEditor;
	}

	public JButton getBackButton() {
		return this.backButton;
	}

	private boolean backOK = true;

	public boolean isBackOK() {
		return this.backOK;
	}

	public void setBackOK(boolean ok) {
		this.backOK = ok;
	}

	public JCheckBoxMenuItem getConsoleMenuItem() {
		return this.consoleMenuItem;
	}

	public JCheckBoxMenuItem getIFrameMenuItem() {
		return this.iFrameMenuItem;
	}

	public JMenuItem getStepMenuItem() {
		return this.stepMenuItem;
	}

	public JCheckBoxMenuItem getDebugMenuItem() {
		return this.debugMenuItem;
	}

	public JCheckBoxMenuItem getDebuggerFrameMenuItem() {
		return this.debuggerFrameMenuItem;
	}

}
