package simulation;

import java.io.PrintWriter;
import java.io.StringWriter;

import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

import model.Play;
import simulation.listener.EventObject;
import theater.Actor;
import theater_intern.IComponent;
import theater_intern.IStage;
import theater_intern.StopException;
import util.ResourceManager;
import editor.SolistEditor;

public class ActSimulator extends Thread {

	IStage newStage;
	boolean step;

	public ActSimulator(boolean step) {
		this.setPriority(Thread.MAX_PRIORITY);
		this.newStage = null;
		this.step = step;
	}

	public void run() {
		Play play = Play.getPlay();
		IStage stage = play.getActiveStage();
		IComponent iComp = stage.getSolist();
		if (iComp != null) {
			Actor actor = (Actor) IComponent.getComp(iComp);
			try {
				if (step) {
					try {
						SwingUtilities.invokeAndWait(new Runnable() {
							public void run() {
								SimulationManager.getSimulationManager()
										.handleStep();
							}
						});
					} catch (Throwable th) {
					}
				}
				actor.main();
				// Flag: SolistDebugger
				// SolistDebugger.getSolistDebugger().run(actor);
				SimulationManager.getSimulationManager().handleEnd();
			} catch (StopException exc) {
				// System.out.println("StopException wurde geworfen");
			} catch (ThreadDeath th) {
				// System.out.println("ThreadDeathException wurde geworfen");
			} catch (Throwable th) {
				th.printStackTrace();
				StringWriter sw = new StringWriter();
				PrintWriter w = new PrintWriter(sw);
				th.printStackTrace(w);
				String msg = sw.toString();
				int i = msg.indexOf(SolistEditor.CLASS_NAME + ".java");
				if (i > -1) {
					i = msg.indexOf('\n', i + 1);
					if (i > -1) {
						msg = msg.substring(0, i);
					}
				}
				JOptionPane.showMessageDialog(Play.getPlay().getPlayFrame(),
						ResourceManager.getResourceManager().getValue(
								"rts.error")
								+ ": \n\n" + msg, ResourceManager
								.getResourceManager().getValue("rts.title"),
						JOptionPane.ERROR_MESSAGE);
				SimulationManager.getSimulationManager().handleEnd();
			} finally {
				try {
					Play.getPlay().getActivePerformance().stopSimulation();
				} catch (StopException exc) {
					// wird geworfen, wenn Ende erreicht (handleAPIStop)
				}
			}
		}

	}

	public void insertEventObject(final EventObject obj) {
		new Thread(new Runnable() {
			public void run() {
				obj.call();
			}
		}).start();
	}

	public void executeEventQueue() {
		// wird bereits beim insert aufgerufen
	}

	public void setStage(IStage stage) {
		this.newStage = stage;
	}

	private void handleStageChange() {
		IStage currentStage = Play.getPlay().getActiveStage();
		if (newStage != null && newStage != currentStage) {
			Play.getPlay().setActiveStage(newStage);
			newStage = null;
			Play.getPlay().getStagePanel().requestFocusInWindow();
		}
	}

}
