package listener;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.JFileChooser;

import model.Play;
import util.IO;
import util.ResourceManager;
import editor.Editor;
import editor.SolistEditor;

public class LoadProgramListener implements ActionListener {

	public void actionPerformed(ActionEvent e) {
		Play play = Play.getPlay();
		JFileChooser chooser = SaveProgramListener.getFileChooser();
		int returnVal = chooser.showOpenDialog(Play.getPlay().getPlayFrame());
		if (returnVal == JFileChooser.APPROVE_OPTION) {
			try {
				Editor editor = SolistEditor.getSolistEditor().getEditor();
				File from = chooser.getSelectedFile();
				File to = new File(play.getDirectory() + File.separatorChar
						+ SolistEditor.CLASS_NAME + ".txt");
				IO.copyMediaFile(from, to);
				editor.getEditorPanel().loadFile(to);
				editor.setChanged(true);
				Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
						ResourceManager.getResourceManager().getValue(
								"msg.program.loaded"));
			} catch (Throwable th) {
				th.printStackTrace();
			}
		} else {
			Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
					ResourceManager.getResourceManager().getValue(
							"msg.actioncanceled"));
		}

	}

}
