package compiler.precompiler;

import java.util.ArrayList;

public class TokenList {
	private Token head;
	private Token tail;

	StringBuffer res;

	TokenList(Token head, Token tail) {
		this.head = head;
		this.tail = tail;
	}

	private void printSpecialTokens(Token st) {
		if (st != null) {
			printSpecialTokens(st.specialToken);
			res.append(st.image);
		}
	}

	public String print() {
		int number = 0;
		res = new StringBuffer();
		for (Token p = head; p != tail; p = p.next) {
			printSpecialTokens(p.specialToken);
			MyToken myT = (MyToken) p;
			for (int i = 0; i < myT.openBracket; i++) {
				res.append("{");
			}
			for (int i = 0; i < myT.elseOpenBracket; i++) {
				res.append("{");
			}
			if (myT.leftParenthesis) {
				String param = genParams(myT.blocks);
				res
						.append("debugger.SolistDebugger.getSolistDebugger().traceB("
								+ (number++)
								+ (param.equals("") ? "" : ",")
								+ param + ") && (");
			}
			if (myT.isTrace) {
				String param = genParams(myT.blocks);
				res.append("debugger.SolistDebugger.getSolistDebugger().trace("
						+ (number++) + (param.equals("") ? "" : ",") + param
						+ ");");
			}
			if (myT.forupdate) {
				String param = genParams(myT.blocks);
				res.append("debugger.SolistDebugger.getSolistDebugger().trace("
						+ (number++) + (param.equals("") ? "" : ",") + param
						+ "),");
			}
			if (myT.enddo) {
				// res.append("trace();}");
				res.append("}");
			}
			if (myT.makePublic) {
				res.append(" public ");
			}

			res.append(p.image);

			if (myT.classname != null && myT.classname.equals("Solist")) {
				res
						.append("static final long serialVersionUID = 8962277232270632278L; "
								+ "public "
								+ myT.classname
								+ "() { super(); } "
								+ "public "
								+ myT.classname
								+ "("
								+ myT.classname
								+ " solist) { super(solist); } ");
			}

			for (int i = 0; i < myT.closeBracket; i++) {
				res.append("}");
			}
			for (int i = 0; i < myT.elseCloseBracket; i++) {
				res.append("}");
			}
			if (myT.rightParenthesis) {
				res.append(")");
			}
		}
		return res.toString();
	}

	private String genParams(ArrayList<ArrayList<VariableInfo>> blocks) {
		String res = "";
		for (ArrayList<VariableInfo> block : blocks) {
			for (VariableInfo v : block) {
				res += "\"" + v.type + "\",";
				res += "\"" + v.name + "\",";
				res += v.name + ",";
			}
		}
		if (!res.equals("") && res.charAt(res.length() - 1) == ',') {
			res = res.substring(0, res.length() - 1);
		}
		return res;
	}

}
