package view;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.Icon;
import javax.swing.JButton;

import model.Play;

public class NewPropButton extends JButton implements KeyListener,
		MouseListener {

	boolean shiftDown;

	public NewPropButton(Icon i) {
		super(i);
		shiftDown = false;
		addMouseListener(this);
	}

	public boolean isShiftDown() {
		return this.shiftDown;
	}

	@Override
	public void mouseClicked(MouseEvent e) {
	}

	@Override
	public void mouseEntered(MouseEvent e) {
	}

	@Override
	public void mouseExited(MouseEvent e) {
	}

	@Override
	public void mousePressed(MouseEvent e) {
		if (e.isShiftDown()) {
			shiftDown = true;
			addKeyListener(this);
		}

	}

	@Override
	public void mouseReleased(MouseEvent e) {

	}

	@Override
	public void keyPressed(KeyEvent e) {

	}

	@Override
	public void keyReleased(KeyEvent e) {
		if (e.getKeyCode() == KeyEvent.VK_SHIFT) {
			shiftDown = false;
			removeKeyListener(this);
			Play.getPlay().getPlayFrame().getGlassPane().destroy();
		}

	}

	@Override
	public void keyTyped(KeyEvent e) {
	}

}
