package util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;

/**
 * Hilfsroutinen zum Umgang mit Dateien
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class IO {

	/**
	 * Kopiert eine Datei aus den Ressourcen der Theater-jar-Datei in eine
	 * andere Datei
	 * 
	 * @param fromResources
	 * @param to
	 */
	public static void copyResTextFile(String fromResources, String to) {
		BufferedReader in = null;
		PrintStream out = null;
		try {
			InputStream is = ResourceLoader.class.getClassLoader()
					.getResourceAsStream("resources/" + fromResources);
			in = new BufferedReader(new InputStreamReader(is));
			out = new PrintStream(new FileOutputStream(to));
			String eingabe = null;
			while ((eingabe = in.readLine()) != null) {
				out.println(eingabe);
			}
		} catch (Throwable exc) {
			exc.printStackTrace();
		} finally {
			try {
				if (out != null) {
					out.close();
				}
				if (in != null) {
					in.close();
				}
			} catch (IOException exc) {
			}
		}
	}

	/**
	 * Kopiert eine Datei aus den Ressourcen der Theater-jar-Datei in eine
	 * andere Datei. Dabei wird in der Datei <name> ersetzt durch einen
	 * konkreten Namen.
	 * 
	 * @param fromResources
	 * @param to
	 * @param name
	 */
	public static void copyResTextFile(String fromResources, String to,
			String name) {
		BufferedReader in = null;
		PrintStream out = null;
		try {
			InputStream is = ResourceLoader.class.getClassLoader()
					.getResourceAsStream("resources/" + fromResources);
			in = new BufferedReader(new InputStreamReader(is));
			out = new PrintStream(new FileOutputStream(to));
			String eingabe = null;
			while ((eingabe = in.readLine()) != null) {
				eingabe = eingabe.replace("<name>", name);
				out.println(eingabe);
			}
		} catch (Throwable exc) {
			exc.printStackTrace();
		} finally {
			try {
				if (out != null) {
					out.close();
				}
				if (in != null) {
					in.close();
				}
			} catch (IOException exc) {
			}
		}
	}

	/**
	 * Kopiert eine Datei aus den Ressourcen der Theater-jar-Datei in eine
	 * andere Datei
	 * 
	 * @param fromResources
	 * @param to
	 */
	public static void copyResMediaFile(String fromResources, File to) {
		BufferedInputStream in = null;
		BufferedOutputStream out = null;
		try {
			InputStream is = ResourceLoader.class.getClassLoader()
					.getResourceAsStream("resources/" + fromResources);
			in = new BufferedInputStream(is);
			out = new BufferedOutputStream(new FileOutputStream(to));
			byte[] buffer = new byte[1024];
			int read = 0;
			while (true) {
				read = in.read(buffer);
				if (read == -1) {
					break;
				}
				out.write(buffer, 0, read);
			}
		} catch (Throwable exc) {
			exc.printStackTrace();
		} finally {
			try {
				if (out != null) {
					out.close();
				}
				if (in != null) {
					in.close();
				}
			} catch (IOException exc) {
			}
		}
	}

	/**
	 * Kopiert eine Datei in eine andere Datei
	 * 
	 * @param src
	 * @param dest
	 * @return
	 */
	public static boolean copyMediaFile(File src, File dest) {
		if (src.getAbsolutePath().equals(dest.getAbsolutePath())) {
			return true;
		}
		byte[] buffer = new byte[1000];
		int read = 0;
		InputStream in = null;
		OutputStream out = null;
		try {
			in = new FileInputStream(src);
			out = new FileOutputStream(dest);
			while (true) {
				read = in.read(buffer);
				if (read == -1) {
					break;
				}
				out.write(buffer, 0, read);
			}
		} catch (Throwable th) {
			th.printStackTrace();
			return false;
		} finally {
			try {
				if (out != null) {
					out.close();
				}
				if (in != null) {
					in.close();
				}
			} catch (IOException exc) {
			}
		}
		return true;
	}

	public static void copyDir(File fromDir, File toDir) {
		if (!toDir.exists()) {
			toDir.mkdir();
		}
		for (File file : fromDir.listFiles()) {
			if (file.isDirectory()) {
				copyDir(file, new File(toDir.getAbsolutePath()
						+ File.separatorChar + file.getName()));
			} else {
				copyMediaFile(file, new File(toDir.getAbsolutePath()
						+ File.separatorChar + file.getName()));
			}

		}
	}

}
