package theater;

import java.awt.Container;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;

import model.Play;

/**
 * TheaterImage ist eine von der Theater-Klasse TheaterImage abgeleitete Klasse,
 * die die Verwendung von Animated-GIF-Ikons ermglicht.
 * <p>
 * </p>
 * Achtung: Die meisten Methoden dieser Klasse berschreiben die von der Klasse
 * TheaterImage geerbten Methoden als leere Methoden, da Animated-GIFs nicht
 * manipuliert werden knnen!
 * 
 * @author Dietrich Boles, Universitt Oldenburg, Germany
 * @version 1.0 (17.07.2009)
 * 
 */
public class TheaterIcon extends TheaterImage {

	/**
	 * intern verwendetes Attribut
	 */
	transient private Image image;

	/**
	 * intern verwendetes Attribut
	 */
	private String filename;

	/**
	 * Konstruktor zum Initialisieren eines TheaterIcons mit einem Bild aus
	 * einer Datei. Erlaubte Bildformate sind gif, jpq und png.
	 * 
	 * @param filename
	 *            Name der Bilddatei; die Datei muss sich im Unterverzeichnis
	 *            "images" des Theaterstcks befinden
	 * @throws IllegalArgumentException
	 *             wird geworfen, wenn die Datei nicht existiert, keine gltige
	 *             Bilddatei ist oder nicht lesbar ist
	 */
	public TheaterIcon(String filename) throws IllegalArgumentException {
		super();
		Play.getPlay().getActivePerformance().checkStop();
		Performance.getPerformance().lock();
		try {
			this.filename = filename;
			this.init();
		} finally {
			Performance.getPerformance().unlock();
		}
	}

	/**
	 * Liefert die Breite des TheaterImages in Pixeln.
	 * 
	 * @return die Breite des TheaterImages in Pixeln
	 */
	public int getWidth() {
		Play.getPlay().getActivePerformance().checkStop();
		Performance.getPerformance().lock();
		try {
			return this.image.getWidth(Play.getPlay().getStagePanel());
		} finally {
			Performance.getPerformance().unlock();
		}
	}

	/**
	 * Liefert die Hhe des TheaterImages in Pixeln.
	 * 
	 * @return die Hhe des TheaterImages in Pixeln
	 */
	public int getHeight() {
		Play.getPlay().getActivePerformance().checkStop();
		Performance.getPerformance().lock();
		try {
			return this.image.getHeight(Play.getPlay().getStagePanel());
		} finally {
			Performance.getPerformance().unlock();
		}
	}

	/**
	 * Ordnet dem TheaterImage eine Farbe zu, in der bei Aufruf der draw- bzw.
	 * fill-Methoden die entsprechenden Graphik-Primitiven gezeichnet werden.
	 * 
	 * @param color
	 *            die neue Zeichenfarbe
	 */
	public void setColor(java.awt.Color color) {
		Play.getPlay().getActivePerformance().checkStop();
	}

	/**
	 * Liefert die aktuelle Zeichenfarbe des TheaterImages.
	 * 
	 * @return die aktuelle Zeichenfarbe des TheaterImages
	 */
	public java.awt.Color getColor() {
		Play.getPlay().getActivePerformance().checkStop();
		return null;
	}

	/**
	 * Setzt den Font, in dem Texte durch nachfolgende Aufrufe der
	 * drawString-Methode in dem TheaterImage gezeichnet werden sollen.
	 * 
	 * @param f
	 *            der neue Font
	 */
	public void setFont(java.awt.Font f) {
		Play.getPlay().getActivePerformance().checkStop();
	}

	/**
	 * Liefert den aktuellen Font des TheaterImages.
	 * 
	 * @return der aktuelle Font des TheaterImages
	 */
	public java.awt.Font getFont() {
		Play.getPlay().getActivePerformance().checkStop();
		return null;
	}

	/**
	 * Zeichnet im TheaterImage eine Linie in der aktuellen Zeichenfarbe.
	 * 
	 * @param x1
	 *            x-Koordinate, von der aus die Linie gezeichnet werden soll
	 * @param y1
	 *            y-Koordinate, von der aus die Linie gezeichnet werden soll
	 * @param x2
	 *            x-Koordinate, bis wohin die Linie gezeichnet werden soll
	 * @param y2
	 *            y-Koordinate, bis wohin die Linie gezeichnet werden soll
	 */
	public void drawLine(int x1, int y1, int x2, int y2) {
		Play.getPlay().getActivePerformance().checkStop();
	}

	/**
	 * Zeichnet im TheaterImage ein Rechteck in der aktuellen Zeichenfarbe.
	 * 
	 * @param x
	 *            x-Koordinate der linken oberen Ecke des Rechtecks
	 * @param y
	 *            y-Koordinate der linken oberen Ecke des Rechtecks
	 * @param width
	 *            Breite des Rechtecks (in Pixeln)
	 * @param height
	 *            Hhe des Rechtecks (in Pixeln)
	 */
	public void drawRect(int x, int y, int width, int height) {
		Play.getPlay().getActivePerformance().checkStop();
	}

	/**
	 * Zeichnet im TheaterImage ein Oval in der aktuellen Zeichenfarbe.
	 * 
	 * @param x
	 *            x-Koordinate der linken oberen Ecke des Ovals
	 * @param y
	 *            y-Koordinate der linken oberen Ecke des Ovals
	 * @param width
	 *            Breite des Ovals in Pixeln
	 * @param height
	 *            Hhe des Ovals in Pixeln
	 */
	public void drawOval(int x, int y, int width, int height) {
		Play.getPlay().getActivePerformance().checkStop();
	}

	/**
	 * Zeichnet im TheaterImage ein Polygon in der aktuellen Zeichenfarbe. Es
	 * wird automatisch ein Linie hinzugefgt, die das Polygon schliet.
	 * 
	 * @param xPoints
	 *            x-Koordinaten der Linien
	 * @param yPoints
	 *            y-Koordinaten der Linien
	 * @param nPoints
	 *            Anzahl der Liniensegmente
	 */
	public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
		Play.getPlay().getActivePerformance().checkStop();
	}

	/**
	 * Zeichnet im TheaterImage einen Text im aktuell gesetzten Font.
	 * 
	 * @param string
	 *            der zu zeichnende Text
	 * @param x
	 *            x-Koordinate, an der der Text beginnen soll
	 * @param y
	 *            y-Koordinate, an der der Text beginnen soll
	 */
	public void drawString(String string, int x, int y) {
		Play.getPlay().getActivePerformance().checkStop();
	}

	/**
	 * Zeichnet ein existierendes TheaterImage an einer bestimmten Stelle in das
	 * aufgerufene TheaterImage
	 * 
	 * @param image
	 *            das TheaterImage, das gezeichnet werden soll (darf nicht null
	 *            sein)
	 * @param x
	 *            x-Koordinate, an der das Image gezeichnet werden soll
	 * @param y
	 *            y-Koordinate, an der das Image gezeichnet werden soll
	 */
	public void drawImage(TheaterIcon image, int x, int y) {
		Play.getPlay().getActivePerformance().checkStop();
	}

	/**
	 * Fllt das gesamte TheaterImage in der aktuellen Zeichenfarbe.
	 */
	public void fill() {
		Play.getPlay().getActivePerformance().checkStop();
	}

	/**
	 * Zeichnet im TheaterImage ein geflltes Rechteck in der aktuellen
	 * Zeichenfarbe.
	 * 
	 * @param x
	 *            x-Koordinate der linken oberen Ecke des Rechtecks
	 * @param y
	 *            y-Koordinate der linken oberen Ecke des Rechtecks
	 * @param width
	 *            Breite des Rechtecks (in Pixeln)
	 * @param height
	 *            Hhe des Rechtecks (in Pixeln)
	 */
	public void fillRect(int x, int y, int width, int height) {
		Play.getPlay().getActivePerformance().checkStop();
	}

	/**
	 * Zeichnet im TheaterImage ein geflltes Oval in der aktuellen
	 * Zeichenfarbe.
	 * 
	 * @param x
	 *            x-Koordinate der linken oberen Ecke des Ovals
	 * @param y
	 *            y-Koordinate der linken oberen Ecke des Ovals
	 * @param width
	 *            Breite des Ovals in Pixeln
	 * @param height
	 *            Hhe des Ovals in Pixeln
	 */
	public void fillOval(int x, int y, int width, int height) {
		Play.getPlay().getActivePerformance().checkStop();
	}

	/**
	 * Zeichnet im TheaterImage ein geflltes Polygon in der aktuellen
	 * Zeichenfarbe. Es wird automatisch ein Linie hinzugefgt, die das Polygon
	 * schliet.
	 * 
	 * @param xPoints
	 *            x-Koordinaten der Linien
	 * @param yPoints
	 *            y-Koordinaten der Linien
	 * @param nPoints
	 *            Anzahl der Liniensegmente
	 */
	public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
		Play.getPlay().getActivePerformance().checkStop();
	}

	/**
	 * Lscht ein TheaterImage.
	 */
	public void clear() {
		Play.getPlay().getActivePerformance().checkStop();
	}

	/**
	 * Setzt ein bestimmtes Pixel des TheaterImages auf eine bestimmte Farbe.
	 * 
	 * @param x
	 *            x-Koordinate des Pixels
	 * @param y
	 *            y-Koordinate des Pixels
	 * @param color
	 *            neue Farbe des Pixels
	 */
	public void setColorAt(int x, int y, java.awt.Color color) {
		Play.getPlay().getActivePerformance().checkStop();
	}

	/**
	 * Liefert die Farbe eines bestimmten Pixels des TheaterImages.
	 * 
	 * @param x
	 *            x-Koordinate des Pixels
	 * @param y
	 *            y-Koordinate des Pixels
	 * @return die Farbe eines bestimmten Pixels des TheaterImages
	 */
	public java.awt.Color getColorAt(int x, int y) {
		Play.getPlay().getActivePerformance().checkStop();
		return null;
	}

	/**
	 * Spiegelt das TheaterImage horizontal. Achtung: Die Gre des Bildes wird
	 * dabei nicht verndert!
	 */
	public void mirrorHorizontally() {
		Play.getPlay().getActivePerformance().checkStop();
	}

	/**
	 * Spiegelt das TheaterImage vertikal. Achtung: Die Gre des Bildes wird
	 * dabei nicht verndert!
	 */
	public void mirrorVertically() {
		Play.getPlay().getActivePerformance().checkStop();
	}

	/**
	 * Dreht das TheaterImage um eine bestimmte Gradzahl. Achtung: Die Gre des
	 * Bildes wird dabei nicht verndert!
	 * 
	 * @param degrees
	 *            Gradzahl der Drehung
	 */
	public void rotate(int degrees) {
		Play.getPlay().getActivePerformance().checkStop();
	}

	/**
	 * Skaliert das TheaterImage auf eine bestimmte Gre.
	 * 
	 * @param width
	 *            die neue Breite des TheaterImages
	 * @param height
	 *            die neue Hhe des TheaterImages
	 */
	public void scale(int width, int height) {
		Play.getPlay().getActivePerformance().checkStop();
	}

	/**
	 * Intern wird ein TheaterImage durch ein
	 * java.awt.image.BufferedImage-Objekt realisiert. Diese Methode liefert das
	 * entsprechende Objekt. Achtung: Einige Methoden tauschen intern das
	 * BufferedImage-Objekt aus!
	 * 
	 * @return das aktuelle interne BufferedImage-Objekt
	 */
	public java.awt.Image getAwtImage() {
		Play.getPlay().getActivePerformance().checkStop();
		Performance.getPerformance().lock();
		try {
			return this.image;
		} finally {
			Performance.getPerformance().unlock();
		}
	}

	// interne Methoden

	/**
	 * interne Methode zur Initialisierung
	 * 
	 * @throws IllegalArgumentException
	 */
	private void init() throws IllegalArgumentException {
		try {
			File f = new File(Play.getPlay().getDirectory() + "/" + "images"
					+ "/" + this.filename);
			if (!f.exists()) {
				throw new IllegalArgumentException();
			}
			MediaTracker tracker = new MediaTracker(new Container());
			URL url = f.toURI().toURL();
			this.image = Toolkit.getDefaultToolkit().createImage(url);
			tracker.addImage(this.image, 1);
			tracker.waitForID(1);
		} catch (Throwable e) {
			throw new IllegalArgumentException(e.getMessage());
		}
	}

	/**
	 * interne Methode zur Serialisierung
	 * 
	 * @param s
	 * @throws IOException
	 */
	private synchronized void writeObject(ObjectOutputStream s)
			throws IOException {
		s.writeObject(this.filename);

	}

	/**
	 * interne Methode zur Deserialisierung
	 * 
	 * @param s
	 * @throws IOException
	 * @throws ClassNotFoundException
	 */
	private synchronized void readObject(ObjectInputStream s)
			throws IOException, ClassNotFoundException {
		this.filename = (String) s.readObject();
		this.init();
	}

	/**
	 * interne Methode fr die Serialisierung
	 * 
	 * @return
	 */
	boolean writeTheaterImageData() {
		return false;
	}

}
