package simulation.listener;

import theater.Component;
import theater.KeyInfo;
import theater.Stage;

public class KeyReleasedObject extends EventObject {

	public KeyReleasedObject(Component comp, KeyInfo keyInfo) {
		super(comp, keyInfo);
	}

	public KeyReleasedObject(Stage stage, KeyInfo keyInfo) {
		super(stage, keyInfo);
	}

	public void call() {
		KeyInfo eventInfo = (KeyInfo)this.eventInfo;
		if (comp != null) {
			if (comp.isHandlingKeyEvents() && !eventInfo.isConsumed()) {
				comp.keyReleased(eventInfo);
			}
		} else {
			if (stage.isHandlingKeyEvents() && !eventInfo.isConsumed()) {
				stage.keyReleased(eventInfo);
			}
		}
	}
}
