package simulation;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Observable;
import java.util.Observer;

import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

import listener.LoadStageListener;
import listener.SaveStageListener;
import model.Play;
import simulation.listener.EventObject;
import theater.Actor;
import theater.Performance;
import theater.Stage;
import theater_intern.IComponent;
import theater_intern.IPerformance;
import theater_intern.IStage;
import theater_intern.StopException;
import theater_intern.TheaterObservable;
import theater_intern.TheaterObserver;
import util.ResourceManager;
import view.InstructionFrame;

import compiler.CompileManager;
import debugger.SolistDebugger;

import editor.SolistEditor;

public class ActSimulationManager extends SimulationManager implements
		ActionListener, Observer {

	private final static String TMP_FILENAME = "SolistTmpStage";
	private final static int MAX_JOIN_TIME = 5000;

	private JButton startButton, pauseButton, stopButton, backButton,
			resetButton, stepButton;
	private JMenuItem startItem, pauseItem, stopItem, backItem, resetItem,
			stepItem;
	private JToggleButton debugButton;
	private JCheckBoxMenuItem debugItem;

	private ActSimulator simulator;

	private File tmpStageFile;

	public ActSimulationManager(JButton startButton, JButton pauseButton,
			JButton stopButton, JButton backButton, JButton resetButton,
			JButton stepButton, JMenuItem startItem, JMenuItem pauseItem,
			JMenuItem stopItem, JMenuItem backItem, JMenuItem resetItem,
			JMenuItem stepMenuItem, JToggleButton debugButton,
			JCheckBoxMenuItem debugItem) {
		this.startButton = startButton;
		this.pauseButton = pauseButton;
		this.stopButton = stopButton;
		this.backButton = backButton;
		this.resetButton = resetButton;
		this.stepButton = stepButton;
		this.startItem = startItem;
		this.pauseItem = pauseItem;
		this.stopItem = stopItem;
		this.backItem = backItem;
		this.resetItem = resetItem;
		this.stepItem = stepMenuItem;
		this.debugButton = debugButton;
		this.debugItem = debugItem;

		this.startButton.setEnabled(false);
		this.startItem.setEnabled(false);
		this.stepButton.setEnabled(false);
		this.stepItem.setEnabled(false);
		this.debugButton.setEnabled(false);
		this.debugItem.setEnabled(false);

		if (!CompileManager.getCompileManager().isCompilationRequired()) {
			this.startButton.setEnabled(true);
			this.startItem.setEnabled(true);
			if (SolistEditor.getSolistEditor().isPrecompileOK()) {
				this.stepButton.setEnabled(true);
				this.stepItem.setEnabled(true);
				this.debugButton.setEnabled(true);
				this.debugItem.setEnabled(true);
			}
		}
		this.pauseButton.setEnabled(false);
		this.pauseItem.setEnabled(false);
		this.stopButton.setEnabled(false);
		this.stopItem.setEnabled(false);
		this.backButton.setEnabled(false);
		this.backItem.setEnabled(false);
		this.resetButton.setEnabled(true);
		this.resetItem.setEnabled(true);
		this.simulator = null;
		this.tmpStageFile = null;
		TheaterObserver.setObserver(new ActTheaterObserver());
		CompileManager.getCompileManager().addObserver(this);
	}

	public void actionPerformed(ActionEvent e) {
		Play.getPlay().setEventQueueActive(true);
		try {
			JComponent c = (JComponent) e.getSource();
			if (c == this.startButton || c == this.startItem) {
				if (Play.getPlay().getActivePerformance().simulationStopped()) {
					this.handleStart(false);
				} else {
					this.handleResume();
				}
			} else if (c == this.stopButton || c == this.stopItem) {
				this.handleStop();
			} else if (c == this.pauseButton || c == this.pauseItem) {
				this.handlePause();
			} else if (c == this.backButton || c == this.backItem) {
				this.handleBack();
			} else if (c == this.resetButton || c == this.resetItem) {
				this.handleReset();
			} else if (c == this.stepButton || c == this.stepItem) {
				this.handleStep();
			}
		} finally {
			Play.getPlay().setEventQueueActive(false);
		}
	}

	public void handleStart(boolean step) {
		this.startButton.setEnabled(false);
		this.startItem.setEnabled(false);
		this.stepButton.setEnabled(false);
		this.stepItem.setEnabled(false);
		this.pauseButton.setEnabled(true);
		this.pauseItem.setEnabled(true);
		this.stopButton.setEnabled(true);
		this.stopItem.setEnabled(true);
		this.backButton.setEnabled(false);
		this.backItem.setEnabled(false);
		this.resetButton.setEnabled(true);
		this.resetItem.setEnabled(true);

		if (Play.getPlay().getActiveStage() == null) {
			this.handleEnd();
			return;
		}

		if (Play.getPlay().isSimulator()) {
			Play.getPlay().getPlayFrame().getCompileButton().setEnabled(false);
			Play.getPlay().getPlayFrame().getCompileItem().setEnabled(false);
		}
		Play.getPlay().getPlayFrame().switchRunResume(false);
		// InstructionFrame.getInstructionFrame().disableButtons();

		this.cancelSimulator();
		this.serializeTmp();
		this.reinitSolist();

		SolistEditor.getSolistEditor().getEditorPanel().locking(true);
		Play.getPlay().getPlayFrame().getCompileButton().setEnabled(false);
		Play.getPlay().getPlayFrame().getCompileItem().setEnabled(false);

		SolistDebugger.getSolistDebugger().reset();

		Play.getPlay().getActivePerformance().startSimulation();

		this.startSimulator(step);

		Play.getPlay().getPlayFrame().getMessagePanel()
				.writeInfo(
						ResourceManager.getResourceManager().getValue(
								"msg.simstarted"));
	}

	public void handleResume() {
		this.startButton.setEnabled(false);
		this.startItem.setEnabled(false);
		this.stepButton.setEnabled(false);
		this.stepItem.setEnabled(false);
		this.pauseButton.setEnabled(true);
		this.pauseItem.setEnabled(true);
		this.stopButton.setEnabled(true);
		this.stopItem.setEnabled(true);
		this.backButton.setEnabled(false);
		this.backItem.setEnabled(false);
		this.resetButton.setEnabled(true);
		this.resetItem.setEnabled(true);

		// InstructionFrame.getInstructionFrame().disableButtons();

		Play.getPlay().getActivePerformance().resumeRequest();

		Play.getPlay().getPlayFrame().getMessagePanel()
				.writeInfo(
						ResourceManager.getResourceManager().getValue(
								"msg.simresumed"));
	}

	public void handlePause() {
		new SwingWorker<Object, Object>() {
			public Object doInBackground() {
				IPerformance perf = Play.getPlay().getActivePerformance();
				perf.forceLock();
				try {
					perf.suspendRequest();
				} finally {
					perf.forceUnlock();
				}
				return null;
			}

			protected void done() {
				// startButton.setEnabled(true);
				// startItem.setEnabled(true);
				// pauseButton.setEnabled(false);
				// pauseItem.setEnabled(false);
				//
				// Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
				// ResourceManager.getResourceManager().getValue(
				// "msg.simpaused"));
			}
		}.execute();
	}

	public void setPause() {
		try {
			SwingUtilities.invokeAndWait(new Runnable() {
				public void run() {
					ActSimulationManager.this.startButton.setEnabled(true);
					ActSimulationManager.this.startItem.setEnabled(true);
					if (SolistEditor.getSolistEditor().isPrecompileOK()) {
						ActSimulationManager.this.stepButton.setEnabled(true);
						ActSimulationManager.this.stepItem.setEnabled(true);
					}
					ActSimulationManager.this.pauseButton.setEnabled(false);
					ActSimulationManager.this.pauseItem.setEnabled(false);
					InstructionFrame.getInstructionFrame().enableButtons();
					Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
							ResourceManager.getResourceManager().getValue(
									"msg.simpaused"));
				}
			});
		} catch (InterruptedException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		}
	}

	public void handleAPISuspend() {
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				ActSimulationManager.this.startButton.setEnabled(true);
				ActSimulationManager.this.startItem.setEnabled(true);
				if (SolistEditor.getSolistEditor().isPrecompileOK()) {
					ActSimulationManager.this.stepButton.setEnabled(true);
					ActSimulationManager.this.stepItem.setEnabled(true);
				}
				ActSimulationManager.this.pauseButton.setEnabled(false);
				ActSimulationManager.this.pauseItem.setEnabled(false);
				InstructionFrame.getInstructionFrame().enableButtons();
				// stopButton.setEnabled(true);
				// stopItem.setEnabled(true);
				// backButton.setEnabled(false);
				// backItem.setEnabled(false);
				// resetButton.setEnabled(true);
				// resetItem.setEnabled(true);

				Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
						ResourceManager.getResourceManager().getValue(
								"msg.simpaused"));
			}
		});

		Play.getPlay().getActivePerformance().forceUnlock();
		Play.getPlay().getActivePerformance().suspendRequest();
		Play.getPlay().getActivePerformance().checkStop();
	}

	public void handleBack() {
		this.cancelSimulator();
		this.deserializeTmp();
		SolistEditor.getSolistEditor().getEditorPanel().locking(false);
		Play.getPlay().getPlayFrame().getCompileButton().setEnabled(true);
		Play.getPlay().getPlayFrame().getCompileItem().setEnabled(true);
		Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
				ResourceManager.getResourceManager().getValue("msg.simback"));
	}

	// MyButton mystopButton = (MyButton) stopButton;

	public void handleStop() {
		// this.startButton.setEnabled(true);
		// this.startItem.setEnabled(true);
		// if (SolistEditor.getSolistEditor().isPrecompileOK()) {
		// this.stepButton.setEnabled(true);
		// this.stepItem.setEnabled(true);
		// }
		// this.pauseButton.setEnabled(false);
		// this.pauseItem.setEnabled(false);
		// InstructionFrame.getInstructionFrame().enableButtons();
		// SolistEditor.getSolistEditor().getEditorPanel().locking(false);
		// Play.getPlay().getPlayFrame().getCompileButton().setEnabled(true);
		// Play.getPlay().getPlayFrame().getCompileItem().setEnabled(true);

		new SwingWorker<Object, Object>() {
			public Object doInBackground() {

				IPerformance perf = Play.getPlay().getActivePerformance();
				SimulationManager.getSimulationManager().getSimulator().interrupt();
				perf.forceLock();
				try {
					perf.stopRequest();
				} finally {
					perf.forceUnlock();
				}

				try {
					ActSimulationManager.this.simulator
							.join(ActSimulationManager.MAX_JOIN_TIME);
				} catch (InterruptedException e) {
				}

				return null;
			}

			protected void done() {
				if (ActSimulationManager.this.simulator != null
						&& ActSimulationManager.this.simulator.isAlive()) {
					ActSimulationManager.this.cancelSimulator();
					JOptionPane.showMessageDialog(null, ResourceManager
							.getResourceManager().getValue("msg.simcanceled"),
							ResourceManager.getResourceManager().getValue(
									"msg.error"), JOptionPane.ERROR_MESSAGE);
					Play.getPlay().reset();
				}

				startButton.setEnabled(true);
				startItem.setEnabled(true);
				if (SolistEditor.getSolistEditor().isPrecompileOK()) {
					stepButton.setEnabled(true);
					stepItem.setEnabled(true);
				}
				pauseButton.setEnabled(false);
				pauseItem.setEnabled(false);
				InstructionFrame.getInstructionFrame().enableButtons();
				SolistEditor.getSolistEditor().getEditorPanel().locking(false);
				Play.getPlay().getPlayFrame().getCompileButton().setEnabled(
						true);
				Play.getPlay().getPlayFrame().getCompileItem().setEnabled(true);
			}
		}.execute();
	}

	public void setStop() {
		try {
			SwingUtilities.invokeAndWait(new Runnable() {
				public void run() {
					// if (simulator != null && simulator.isAlive()) {
					// cancelSimulator();
					// JOptionPane.showMessageDialog(null, ResourceManager
					// .getResourceManager().getValue("msg.simcanceled"),
					// ResourceManager.getResourceManager().getValue(
					// "msg.error"), JOptionPane.ERROR_MESSAGE);
					// Play.getPlay().reset();
					// }
					ActSimulationManager.this.startButton.setEnabled(true);
					ActSimulationManager.this.startItem.setEnabled(true);
					if (SolistEditor.getSolistEditor().isPrecompileOK()) {
						ActSimulationManager.this.stepButton.setEnabled(true);
						ActSimulationManager.this.stepItem.setEnabled(true);
					}
					ActSimulationManager.this.pauseButton.setEnabled(false);
					ActSimulationManager.this.pauseItem.setEnabled(false);
					ActSimulationManager.this.stopButton.setEnabled(false);
					ActSimulationManager.this.stopItem.setEnabled(false);
					if (Play.getPlay().getPlayFrame().isBackOK()) {
						ActSimulationManager.this.backButton.setEnabled(true);
						ActSimulationManager.this.backItem.setEnabled(true);
					}
					ActSimulationManager.this.resetButton.setEnabled(true);
					ActSimulationManager.this.resetItem.setEnabled(true);
					InstructionFrame.getInstructionFrame().enableButtons();
					if (Play.getPlay().isSimulator()) {
						Play.getPlay().getPlayFrame().getCompileButton()
								.setEnabled(true);
						Play.getPlay().getPlayFrame().getCompileItem()
								.setEnabled(true);
					}
					// mystopButton.reset();
					Play.getPlay().getPlayFrame().switchRunResume(true);
					SolistEditor.getSolistEditor().getEditorPanel().locking(
							false);
					Play.getPlay().getPlayFrame().getCompileButton()
							.setEnabled(true);
					Play.getPlay().getPlayFrame().getCompileItem().setEnabled(
							true);
					Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
							ResourceManager.getResourceManager().getValue(
									"msg.simstopped"));
				}
			});
		} catch (InterruptedException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		}
	}

	public void handleAPIStop() {
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				ActSimulationManager.this.startButton.setEnabled(true);
				ActSimulationManager.this.startItem.setEnabled(true);
				if (SolistEditor.getSolistEditor().isPrecompileOK()) {
					ActSimulationManager.this.stepButton.setEnabled(true);
					ActSimulationManager.this.stepItem.setEnabled(true);
				}
				ActSimulationManager.this.pauseButton.setEnabled(false);
				ActSimulationManager.this.pauseItem.setEnabled(false);
				ActSimulationManager.this.stopButton.setEnabled(false);
				ActSimulationManager.this.stopItem.setEnabled(false);
				if (Play.getPlay().getPlayFrame().isBackOK()) {
					ActSimulationManager.this.backButton.setEnabled(true);
					ActSimulationManager.this.backItem.setEnabled(true);
				}
				ActSimulationManager.this.resetButton.setEnabled(true);
				ActSimulationManager.this.resetItem.setEnabled(true);
				InstructionFrame.getInstructionFrame().enableButtons();
				SolistEditor.getSolistEditor().getEditorPanel().locking(false);
				Play.getPlay().getPlayFrame().getCompileButton().setEnabled(
						true);
				Play.getPlay().getPlayFrame().getCompileItem().setEnabled(true);
				if (Play.getPlay().isSimulator()) {
					Play.getPlay().getPlayFrame().getCompileButton()
							.setEnabled(true);
					Play.getPlay().getPlayFrame().getCompileItem().setEnabled(
							true);
				}
				Play.getPlay().getPlayFrame().switchRunResume(true);
				// Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
				// ResourceManager.getResourceManager().getValue(
				// "msg.simstopped"));
			}
		});

		throw new StopException();
	}

	public void handleEnd() {
		this.startButton.setEnabled(true);
		this.startItem.setEnabled(true);
		if (SolistEditor.getSolistEditor().isPrecompileOK()) {
			this.stepButton.setEnabled(true);
			this.stepItem.setEnabled(true);
		}
		this.pauseButton.setEnabled(false);
		this.pauseItem.setEnabled(false);
		this.stopButton.setEnabled(false);
		this.stopItem.setEnabled(false);
		if (Play.getPlay().getPlayFrame().isBackOK()) {
			this.backButton.setEnabled(true);
			this.backItem.setEnabled(true);
		}
		this.resetButton.setEnabled(true);
		this.resetItem.setEnabled(true);
		InstructionFrame.getInstructionFrame().enableButtons();
		SolistEditor.getSolistEditor().getEditorPanel().locking(false);

		Play.getPlay().getPlayFrame().getCompileButton().setEnabled(true);
		Play.getPlay().getPlayFrame().getCompileItem().setEnabled(true);

		Play.getPlay().getPlayFrame().switchRunResume(true);
		Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
				ResourceManager.getResourceManager().getValue("msg.simended"));
	}

	public void handleReset() {
		this.cancelSimulator();
		InstructionFrame.getInstructionFrame().enableButtons();
		SolistEditor.getSolistEditor().getEditorPanel().locking(false);
		Play.getPlay().getPlayFrame().getCompileButton().setEnabled(true);
		Play.getPlay().getPlayFrame().getCompileItem().setEnabled(true);

		this.startButton.setEnabled(false);
		this.startItem.setEnabled(false);
		this.stepButton.setEnabled(false);
		this.stepItem.setEnabled(false);
		if (!CompileManager.getCompileManager().isCompilationRequired()) {
			this.startButton.setEnabled(true);
			this.startItem.setEnabled(true);
			if (SolistEditor.getSolistEditor().isPrecompileOK()) {
				this.stepButton.setEnabled(true);
				this.stepItem.setEnabled(true);
			}
		}
		this.pauseButton.setEnabled(false);
		this.pauseItem.setEnabled(false);
		this.stopButton.setEnabled(false);
		this.stopItem.setEnabled(false);
		this.resetButton.setEnabled(true);
		this.resetItem.setEnabled(true);
		Play.getPlay().getPlayFrame().switchRunResume(true);
		Play.getPlay().reset();
		Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
				ResourceManager.getResourceManager().getValue("msg.simreset"));
	}

	public void handleStep() {
		IPerformance iPerf = Play.getPlay().getActivePerformance();
		if (iPerf.simulationStopped()) {
			handleStart(true);
			this.startButton.setEnabled(true);
			this.startItem.setEnabled(true);
			if (SolistEditor.getSolistEditor().isPrecompileOK()) {
				this.stepButton.setEnabled(true);
				this.stepItem.setEnabled(true);
			}
			this.pauseButton.setEnabled(false);
			this.pauseItem.setEnabled(false);
			InstructionFrame.getInstructionFrame().enableButtons();
		} else {
			iPerf.stepRequest();
		}
		Play.getPlay().getPlayFrame().getMessagePanel()
				.writeInfo(
						ResourceManager.getResourceManager().getValue(
								"msg.simstepped"));
	}

	public void insertEventObject(EventObject obj) {
		if (this.simulator != null) {
			this.simulator.insertEventObject(obj);
		}
	}

	public void executeEventQueue() {
		if (this.simulator != null) {
			this.simulator.executeEventQueue();
		}
	}

	public void setStage(IStage stage) {
		if (this.simulator != null) {
			this.simulator.setStage(stage);
		}
	}

	public void update(Observable o, Object arg) {
		this.startButton.setEnabled(false);
		this.startItem.setEnabled(false);
		this.stepButton.setEnabled(false);
		this.stepItem.setEnabled(false);
		this.debugButton.setEnabled(false);
		this.debugItem.setEnabled(false);

		if (!CompileManager.getCompileManager().isCompilationRequired()) {
			this.startButton.setEnabled(true);
			this.startItem.setEnabled(true);
			if (SolistEditor.getSolistEditor().isPrecompileOK()) {
				this.stepButton.setEnabled(true);
				this.stepItem.setEnabled(true);
				this.debugButton.setEnabled(true);
				this.debugItem.setEnabled(true);
			}
		}

	}

	public Thread getSimulator() {
		return this.simulator;
	}

	private void startSimulator(boolean step) {
		this.simulator = new ActSimulator(step);
		this.simulator.start();
	}

	public void cancelSimulator() {
		if (this.simulator != null && this.simulator.isAlive()) {
			Play.getPlay().getActivePerformance().stopRequest();
			this.simulator.stop();
			try {
				this.simulator.join();
			} catch (Exception exc) {

			}
		}
		this.simulator = null;
	}

	private void serializeTmp() {
		try {
			this.tmpStageFile = File.createTempFile(
					ActSimulationManager.TMP_FILENAME, "ser");
			SaveStageListener.saveStage(this.tmpStageFile);
		} catch (Throwable exc) {
			this.tmpStageFile = null;
		}
	}

	private void deserializeTmp() {
		if (this.tmpStageFile != null) {
			LoadStageListener.loadStage(this.tmpStageFile);
		}
	}

	private void reinitSolist() {
		Stage stage = Performance.getPerformance().getActiveStage();
		Actor oldSolist = stage.getSolist();
		int col = oldSolist.getColumn();
		int row = oldSolist.getRow();
		Actor newSolist = Actor.cloneSolist(oldSolist); // damit
		// Solist-Attribute neu
		// initialisiert werden
		IComponent oldS = IComponent.getIComp(oldSolist);
		IComponent newS = IComponent.getIComp(newSolist);
		newS.copyAttributes(oldS); // damit der neue Solist so ist wie der alte
		stage.setSolist(newSolist, col, row);
		TheaterObservable.getObservable().importantStateChange();
		Play.getPlay().getPlayFrame().getFileTree().repaint();
	}

	public void setButtonsToStart() {
		this.startButton.setEnabled(true);
		this.startItem.setEnabled(true);
		this.stepButton.setEnabled(true);
		this.stepItem.setEnabled(true);
		this.pauseButton.setEnabled(false);
		this.pauseItem.setEnabled(false);
		this.stopButton.setEnabled(false);
		this.stopItem.setEnabled(false);
		this.resetButton.setEnabled(true);
		this.resetItem.setEnabled(true);
		if (Play.getPlay().getPlayFrame().isBackOK()) {
			this.backButton.setEnabled(true);
			this.backItem.setEnabled(true);
		}
	}

}
