package listener;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;

import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;

import model.Play;
import theater_intern.TheaterObservable;
import util.PropertyManager;
import util.ResourceManager;
import util.Utils;
import view.PictureFrame;
import view.PlayFrame;
import console.Console;

/**
 * Startet die Anwendung
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (30.03.2009)
 * 
 */
public class Application {

	public final static String NO_PICTURE_OPTION = "-p";
	public final static String NEW_PLAY_OPTION = "-n";
	public final static String EXISTING_PLAY_OPTION = "-e";
	public final static String ECLIPSE_OPTION = "-eclipse";
	public final static String SIMULATOR_OPTION = "-simulator";
	public final static String SOLIST_OPTION = "-solist";

	public final static String SOLIST_JAR_NAME = "solist.jar";
	public final static String SIMULATOR_JAR_NAME = "simulator.jar";

	private static String[] args;

	public static String java = "java";

	public static void main(String[] args) {

		Application.args = args;
		if (!checkJDK()) {
			chooseJDK();
			System.exit(0);
		}

		PictureThread pth = null;
		try {
			if (Application.withPictureFrame(args)) {
				EventQueue.invokeAndWait(pth = new PictureThread());
				EventQueue.invokeAndWait(new MainThread(args, pth.pframe));
			} else {
				EventQueue.invokeAndWait(new MainThread(args, null));
			}
		} catch (InterruptedException e) {
			Utils.handleInternalError(e);
		} catch (InvocationTargetException e) {
			Utils.handleInternalError(e);
		}
	}

	public static boolean checkJDK() {
		JavaCompiler javac = ToolProvider.getSystemJavaCompiler();
		return javac != null;
	}

	public static void chooseJDK() {
		String jdk = null;
		jdk = PropertyManager.getPropertyManager().getJDK();
		if (jdk != null) {
			String[] newArgs = new String[args.length + 5];
			newArgs[0] = jdk + File.separatorChar + "bin" + File.separatorChar
					+ "java";
			java = newArgs[0];
			newArgs[1] = PropertyManager.getPropertyManager()
					.getInitHeapSpace();
			newArgs[2] = PropertyManager.getPropertyManager().getMaxHeapSpace();
			newArgs[3] = "-jar";
			if (!Application.simulatorOption(args)) {
				newArgs[4] = Application.SOLIST_JAR_NAME;
			} else {
				newArgs[4] = Application.SIMULATOR_JAR_NAME;
			}
			for (int i = 0; i < args.length; i++) {
				newArgs[5 + i] = args[i];
			}
			try {
				PropertyManager.getPropertyManager().setJDK(jdk);
				ProcessBuilder builder = new ProcessBuilder(newArgs);
				builder.start();
				return;
			} catch (IOException exc) {
				JOptionPane.showMessageDialog(null, ResourceManager
						.getResourceManager().getValue("jdkchooser.msg3"),
						ResourceManager.getResourceManager().getValue(
								"jdkchooser.title"), JOptionPane.ERROR_MESSAGE);
				jdk = null;
			}
		}
		while (jdk == null) {
			JOptionPane.showMessageDialog(null, ResourceManager
					.getResourceManager().getValue("jdkchooser.msg"),
					ResourceManager.getResourceManager().getValue(
							"jdkchooser.title"), JOptionPane.PLAIN_MESSAGE);
			JFileChooser chooser = new JFileChooser();
			chooser.setAcceptAllFileFilterUsed(false);
			chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
			int returnVal = chooser.showDialog(null, ResourceManager
					.getResourceManager()
					.getValue("filechooser.jdk.buttontext"));
			if (returnVal != JFileChooser.APPROVE_OPTION) {
				return;
			}
			File dir = chooser.getSelectedFile();
			jdk = dir.getAbsolutePath();

			String[] newArgs = new String[args.length + 5];
			newArgs[0] = jdk + File.separatorChar + "bin" + File.separatorChar
					+ "java";
			newArgs[1] = PropertyManager.getPropertyManager()
					.getInitHeapSpace();
			newArgs[2] = PropertyManager.getPropertyManager().getMaxHeapSpace();
			newArgs[3] = "-jar";
			if (!Application.simulatorOption(args)) {
				newArgs[4] = Application.SOLIST_JAR_NAME;
			} else {
				newArgs[4] = Application.SIMULATOR_JAR_NAME;
			}
			for (int i = 0; i < args.length; i++) {
				newArgs[5 + i] = args[i];
			}
			try {
				PropertyManager.getPropertyManager().setJDK(jdk);
				ProcessBuilder builder = new ProcessBuilder(newArgs);
				builder.start();
			} catch (IOException exc) {
				JOptionPane.showMessageDialog(null, ResourceManager
						.getResourceManager().getValue("jdkchooser.msg2"),
						ResourceManager.getResourceManager().getValue(
								"jdkchooser.title"), JOptionPane.ERROR_MESSAGE);
				jdk = null;
			}
		}
	}

	public static void openPlay(File playDescFile, PictureFrame pframe,
			boolean withPictureFrame, boolean isSimulator) {
		Play play = new Play(playDescFile, isSimulator);
		JFrame frame = play.getPlayFrame();
		TheaterObservable.getObservable().importantStateChange();
		Play.getPlay().getPlayFrame().getFileTree().repaint();
		frame.setVisible(true);
		if (withPictureFrame) {
			pframe.setVisible(false);
		}
	}

	public static void openEmptyPlay(PictureFrame pframe,
			boolean withPictureFrame) {
		Play play = new Play();
		PlayFrame frame = play.getPlayFrame();
		frame.setVisible(true);
		if (withPictureFrame) {
			pframe.setVisible(false);
		}
		frame.getMessagePanel()
				.writeInfo(
						ResourceManager.getResourceManager().getValue(
								"msg.emptystart"));
	}

	public static void openNewPlay(String dirName, PictureFrame pframe,
			boolean withPictureFrame) {
		Play play = new Play(dirName);
		JFrame frame = play.getPlayFrame();
		frame.setVisible(true);
		if (withPictureFrame) {
			pframe.setVisible(false);
		}
	}

	static boolean withPictureFrame(String[] args) {
		return false;
		// if (args == null) {
		// return true;
		// }
		// for (String str : args) {
		// if (str.equals(Application.NO_PICTURE_OPTION)) {
		// return false;
		// }
		// }
		// return true;
	}

	static boolean newPlayOption(String[] args) {
		if (args == null) {
			return false;
		}
		for (String str : args) {
			if (str.equals(Application.NEW_PLAY_OPTION)) {
				return true;
			}
		}
		return false;
	}

	static String getNewPlay(String[] args) {
		for (int i = 0; i < args.length; i++) {
			if (args[i].equals(Application.NEW_PLAY_OPTION)) {
				return args[i + 1];
			}
		}
		return null;
	}

	static boolean simulatorOption(String[] args) {
		if (args == null) {
			return false;
		}
		for (String str : args) {
			if (str.equals(Application.SIMULATOR_OPTION)) {
				return true;
			}
		}
		return false;
	}

	static boolean solistOption(String[] args) {
		if (args == null) {
			return false;
		}
		for (String str : args) {
			if (str.equals(Application.SOLIST_OPTION)) {
				return true;
			}
		}
		return false;
	}

	static boolean existingPlayOption(String[] args) {
		if (args == null) {
			return false;
		}
		for (String str : args) {
			if (str.equals(Application.EXISTING_PLAY_OPTION)) {
				return true;
			}
		}
		return false;
	}

	static String getExistingPlay(String[] args) {
		for (int i = 0; i < args.length; i++) {
			if (args[i].equals(Application.EXISTING_PLAY_OPTION)) {
				return args[i + 1];
			}
		}
		return null;
	}

	public static boolean eclipseOption() {
		if (Application.args == null) {
			return false;
		}
		for (String str : Application.args) {
			if (str.equals(Application.ECLIPSE_OPTION)) {
				return true;
			}
		}
		return false;
	}
}

class PictureThread extends Thread {

	PictureFrame pframe;

	public void run() {
		this.pframe = new PictureFrame();
		this.pframe.setVisible(true);
		try {
			Thread.sleep(0);
		} catch (InterruptedException exc) {
		}
	}
}

class MainThread extends Thread {

	String[] args;
	PictureFrame pframe;

	MainThread(String[] args, PictureFrame pf) {
		this.args = args;
		this.pframe = pf;
	}

	public void run() {

		Console console = Console.getConsole();
		if (!Application.eclipseOption()) {
			System.setOut(new PrintStream(console.getOut()));
			System.setErr(new PrintStream(console.getErr()));
			System.setIn(console.getIn());
		}

		if (Application.newPlayOption(this.args)) {
			Application.openNewPlay(Application.getNewPlay(this.args),
					this.pframe, Application.withPictureFrame(this.args));
		} else if (Application.simulatorOption(this.args)) {
			Application.openPlay(new File(Application
					.getExistingPlay(this.args)
					+ File.separatorChar + Play.XML_FILE), this.pframe, false,
					true);
		} else if (Application.existingPlayOption(this.args)) {
			Application.openPlay(new File(Application
					.getExistingPlay(this.args)
					+ File.separatorChar + Play.XML_FILE), this.pframe,
					Application.withPictureFrame(this.args), false);
		} else {
			Application.openEmptyPlay(this.pframe, Application
					.withPictureFrame(this.args));
		}
	}
}
