package view;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

import model.Play;
import theater.Component;
import theater.NewPropHandler;
import theater.Performance;
import theater.Prop;
import theater_intern.IStage;
import util.ResourceLoader;
import util.ResourceManager;

public class TheaterGlassPane extends JComponent implements MouseListener,
		MouseMotionListener {

	private Component comp;
	private Point mousePoint;
	private Image outside;
	private boolean isDestroyed;
	private NewPropHandler handler;
	private NewPropButton button;
	private Object syncObject = new Object();

	private static TheaterGlassPane pane = null;

	private TheaterGlassPane() {
		outside = ResourceLoader.getImage("outside24.gif");
	}

	public static TheaterGlassPane getPane() {
		if (pane == null) {
			pane = new TheaterGlassPane();
		}
		return pane;
	}

	public void activate(NewPropHandler handler, NewPropButton b) {
		synchronized (syncObject) {
			this.handler = handler;
			this.button = b;
			if (!newComp()) {
				return;
			}
			this.isDestroyed = false;
			this.setVisible(true);
			this.addMouseListener(this);
			this.addMouseMotionListener(this);
			mousePoint = this.getMousePosition();
		}
	}

	public void activate(Component comp) {
		synchronized (syncObject) {
			this.comp = comp;
			this.handler = null;
			this.button = null;
			this.isDestroyed = false;
			this.setVisible(true);
			this.addMouseListener(this);
			this.addMouseMotionListener(this);
			mousePoint = this.getMousePosition();
		}
	}

	private boolean newComp() {
		try {
			this.comp = handler.newProp();
			if (this.comp == null) {
				return false;
			}
		} catch (Throwable th) {
			th.printStackTrace();
			JOptionPane.showMessageDialog(Play.getPlay().getStagePanel(), th
					.toString(), th.getClass().getName(),
					JOptionPane.ERROR_MESSAGE);
			return false;
		}
		return true;
	}

	public void deactivate() {
		synchronized (syncObject) {
			if (button != null && button.isShiftDown()) {
				newComp();
				return;
			}
			this.setVisible(false);
			this.removeMouseListener(this);
			this.removeMouseMotionListener(this);
			repaint();
		}
	}

	public void destroy() {
		synchronized (syncObject) {
			this.isDestroyed = true;
			this.setVisible(false);
			this.removeMouseListener(this);
			this.removeMouseMotionListener(this);
			repaint();
		}
	}

	protected void paintComponent(Graphics g) {
		if (this.isDestroyed) {
			return;
		}
		Image im = this.comp.getImage().getAwtImage();
		if (im == null) {
			return;
		}
		if (mousePoint == null) {
			return;
		}
		StagePanel stagePanel = Play.getPlay().getStagePanel();
		Point stagePoint = SwingUtilities.convertPoint(this, mousePoint,
				stagePanel);
		if (stagePanel.isInsideStage(stagePoint)) {
			Point drawPoint = SwingUtilities.convertPoint(stagePanel,
					stagePanel.getDrawPoint(stagePoint, im), this);
			g.drawImage(im, drawPoint.x + 1, drawPoint.y + 1, null);
		} else {
			g.drawImage(im, mousePoint.x
					- im.getWidth(Play.getPlay().getStagePanel()) / 2,
					mousePoint.y - im.getHeight(Play.getPlay().getStagePanel())
							/ 2, null);
			g.drawImage(outside, mousePoint.x - outside.getWidth(null) / 2,
					mousePoint.y - outside.getHeight(null) / 2, null);
		}
	}

	public void mouseMoved(MouseEvent e) {
		if (this.isDestroyed) {
			return;
		}
		this.mousePoint = e.getPoint();
		repaint();
	}

	public void mousePressed(final MouseEvent e) {
		if (this.isDestroyed) {
			return;
		}
		String msg = "msg.nonewcomp";
		if (e.getButton() == MouseEvent.BUTTON1) {
			StagePanel stagePanel = Play.getPlay().getStagePanel();
			Point stagePoint = SwingUtilities.convertPoint(
					TheaterGlassPane.this, e.getPoint(), stagePanel);
			if (stagePanel.isInsideStage(stagePoint)) {
				msg = "msg.newcomp";
				final int col = stagePanel.getCellColumn(stagePoint.x);
				final int row = stagePanel.getCellRow(stagePoint.y);
//				Thread th = new AddThread(this.comp, col, row);
//				th.start(); :-( kann Fehler produzieren
				IStage.getStage(Play.getPlay().getActiveStage()).add((Prop) comp,
						col, row);
			}
		}
		deactivate();
		Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
				ResourceManager.getResourceManager().getValue(msg));
	}

	public void mouseClicked(MouseEvent e) {
	}

	public void mouseEntered(MouseEvent e) {
	}

	public void mouseExited(MouseEvent e) {
	}

	public void mouseReleased(MouseEvent e) {
	}

	public void mouseDragged(MouseEvent e) {
	}

}

class AddThread extends Thread {

	private Component comp;
	private int col;
	private int row;

	AddThread(Component co, int c, int r) {
		comp = co;
		col = c;
		row = r;
	}

	public void run() {
		Performance.getPerformance().lock();
		try {
			IStage.getStage(Play.getPlay().getActiveStage()).add((Prop) comp,
					col, row);
		} finally {
			Performance.getPerformance().unlock();
		}
	}
}
