package editor.listener;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import util.ResourceManager;
import editor.Editor;

/**
 * Ausfhren einer Redo-Aktion
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class RedoListener implements ActionListener {

	Editor editor;

	public RedoListener(Editor editor) {
		this.editor = editor;
	}

	public void actionPerformed(ActionEvent e) {
		if (editor.getUndoManager().canRedo()) {
			editor.getUndoManager().redo();
			this.editor.getEditorPanel().calcNumberOfLines();
			this.editor.getEditorPanel().getJavaDocument().rehighlight();
			editor.setChanged(true);
			this.editor.getMessagePanel().writeInfo(
					ResourceManager.getResourceManager().getValue(
							"msg.editor.redo"));
		}
		editor.getEditorPanel().requestFocusInWindow();
	}

}
