package listener;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import javax.swing.JOptionPane;

import model.Play;
import simulation.SimulationManager;
import theater.Performance;
import theater_intern.TheaterObservable;
import util.ResourceManager;
import util.SolistThread;
import util.Utils;

/**
 * Listener zum Ausfhren einer Methode (ohne Parameter)
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class MethodInvocation implements ActionListener {

	public final static int WAIT_TIME = 5000;

	Method method;
	Object obj;
	MethodThread thread;
	ResourceManager man;
	boolean duringRun;
	boolean isVoid;

	public MethodInvocation(Method m, Object o) {
		this.method = m;
		this.isVoid = m.getReturnType() == void.class;
		this.obj = o;
		this.man = ResourceManager.getResourceManager();
	}

	public void actionPerformed(ActionEvent e) {
		if (Play.getPlay().getActivePerformance().simulationRunning()) {
			new SolistThread(new Runnable() {
				public void run() {
					MethodInvocation.this.duringRun = true;
					MethodInvocation.this.perform();
				}
			}).call();
			Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
					ResourceManager.getResourceManager().getValue(
							"msg.methodcall1")
							+ " "
							+ this.method.getName()
							+ " "
							+ ResourceManager.getResourceManager().getValue(
									"msg.methodcall2"));
		} else {
			this.duringRun = false;
			this.perform();
		}
	}

	@SuppressWarnings("deprecation")
	void perform() {
		try {
			// Play.getPlay().setEventQueueActive(true);
			this.thread = new MethodThread(this);
			this.thread.start();
			this.thread.join(MethodInvocation.WAIT_TIME);
			// wenn die Ausfhrung einer Methode lnger als eine
			// bestimmte
			// Schwelle berschreitet, wird sie abgebrochen; das
			// verhindert
			// Endlosschleifen
			if (this.thread.isAlive()) {
				this.thread.stop();
				this.thread.join();
			}
			if (!this.duringRun) {
				TheaterObservable.getObservable().importantStateChange();
				this.showResult();
			}
		} catch (Throwable exc) {
			exc.printStackTrace();
		} finally {
			// Play.getPlay().setEventQueueActive(false);
		}
	}

	void showResult() {
		if (isVoid) {
			return;
		}
		if (this.thread.result == null) {
			this.thread.result = "null";
		}
		JOptionPane.showMessageDialog(Play.getPlay().getStagePanel(), this.method
				.getName()
				+ " "
				+ this.man.getValue("returnvalue")
				+ " "
				+ this.thread.result.toString(), this.man.getValue("callmethodresult"),
				JOptionPane.INFORMATION_MESSAGE);
	}
}

class MethodThread extends Thread {

	MethodInvocation in;
	Object result;

	MethodThread(MethodInvocation in) {
		this.in = in;
	}

	public void run() {
		this.result = null;
		Performance.getPerformance().lock();
		try {
			TheaterObservable.getObservable().setEnabled(false);
			this.in.method.setAccessible(true);
			this.result = this.in.method.invoke(this.in.obj, (Object[]) null);
			TheaterObservable.getObservable().setEnabled(true);
			if (this.in.duringRun) {
				TheaterObservable.getObservable().importantStateChange();
				this.showResult();
			}
		} catch (InvocationTargetException exc) {
			TheaterObservable.getObservable().setEnabled(true);
			if (this.in.duringRun) {
				TheaterObservable.getObservable().importantStateChange();
			}
			final Throwable th = exc.getTargetException();
			if (Utils.dynInstanceof(th, ThreadDeath.class)) {
				Performance.getPerformance().lock(); // Sperre
				EventQueue.invokeLater(new Runnable() {
					public void run() {
						JOptionPane
								.showMessageDialog(null, ResourceManager
										.getResourceManager().getValue(
												"msg.methodcallstopped"),
										ResourceManager.getResourceManager()
												.getValue("msg.error"),
										JOptionPane.ERROR_MESSAGE);
						Play.getPlay().reset(); // alles neu laden, weil in
						// undefiniertem Zustand
						SimulationManager.getSimulationManager().handleReset();
					}
				});
			} else {
				EventQueue.invokeLater(new Runnable() {
					public void run() {
						JOptionPane.showMessageDialog(Play.getPlay()
								.getStagePanel(), th.toString(), th.getClass()
								.getName(), JOptionPane.ERROR_MESSAGE);
					}
				});
			}
		} catch (final Throwable exc) {
			TheaterObservable.getObservable().setEnabled(true);
			if (this.in.duringRun) {
				TheaterObservable.getObservable().importantStateChange();
			}
			EventQueue.invokeLater(new Runnable() {
				public void run() {
					exc.printStackTrace();
					JOptionPane.showMessageDialog(Play.getPlay()
							.getStagePanel(), MethodThread.this.in.man
							.getValue("callmethoderror"), exc.getClass()
							.getName(), JOptionPane.ERROR_MESSAGE);
				}
			});
		} finally {
			Performance.getPerformance().unlock();
		}

	}

	void showResult() {
		if (in.isVoid) {
			return;
		}
		if (this.result == null) {
			this.result = "null";
		}
		JOptionPane.showMessageDialog(Play.getPlay().getStagePanel(), this.in.method
				.getName()
				+ " "
				+ this.in.man.getValue("returnvalue")
				+ " "
				+ this.result.toString(), this.in.man.getValue("callmethodresult"),
				JOptionPane.INFORMATION_MESSAGE);
	}

}
