package view;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.util.Timer;
import java.util.TimerTask;

import javax.swing.BorderFactory;
import javax.swing.JTextArea;

/**
 * Eine TextArea, in der Meldungen ausgegeben werden knnen.
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class MessagePanel extends JTextArea {

	private static long DISPLAY_TIME = 10000;

	private Timer timer;

	/**
	 * Erzeugt ein leeres MessagePanel
	 */
	public MessagePanel() {
		this("");
	}

	/**
	 * Erzeugt ein MessagePanel mit einem initialen Text
	 * 
	 * @param msg
	 */
	public MessagePanel(String msg) {
		this.setBackground(new Color(220, 250, 250));
		this.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
		this.setFocusable(false);
		this.setFont(new Font(Font.SANS_SERIF, Font.BOLD, 12));
		this.setMargin(new Insets(5, 5, 5, 5));
		this.setEditable(false);
		this.setLineWrap(false);
		this.setForeground(Color.DARK_GRAY);
		this.timer = new Timer();
		this.writeInfo(msg);
	}

	/**
	 * Schreibt eine normale Info in das MessagePanel.
	 * 
	 * @param msg
	 */
	public void writeInfo(String msg) {
		this.write(msg, Color.DARK_GRAY);
	}

	/**
	 * Schreibt eine Fehlermeldung in das MessagePanel.
	 * 
	 * @param msg
	 */
	public void writeError(String msg) {
		this.write(msg, Color.RED);
	}


	/**
	 * Lscht das MessagePanel nach der angegebenen Zeit
	 * 
	 * @param msecs
	 */
	public void clear(long msecs) {
		this.timer.schedule(new ClearTask(this), msecs);
	}
	
	private void write(String msg, Color textColor) {
		this.timer.cancel();
		this.timer = new Timer();
		this.setForeground(textColor);
		this.setText(msg);
		this.clear(MessagePanel.DISPLAY_TIME);
	}
}

class ClearTask extends TimerTask {

	MessagePanel panel;

	ClearTask(MessagePanel panel) {
		this.panel = panel;
	}

	public void run() {
		this.panel.setText("");
	}

}
