package debugger;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

import model.Play;
import util.ResourceManager;

public class DebuggerFrame extends JFrame {

	private JSplitPane splitPane;
	private JScrollPane fPanel;
	private JScrollPane vPanel;
	private StackFrameTable stackFrameTable;
	private VariablesTree variablesTree;

	private static DebuggerFrame dFrame = null;

	public static DebuggerFrame getDebuggerFrame() {
		if (dFrame == null) {
			dFrame = new DebuggerFrame();
		}
		return dFrame;
	}

	protected DebuggerFrame() {
		super(ResourceManager.getResourceManager().getValue("debuggerframe.title"));
		setLocation(40, 40);
		this.addWindowListener(new CloseListener(this));
		this.setLayout(new BorderLayout());
				
		this.stackFrameTable = new StackFrameTable();
		this.fPanel = new JScrollPane(stackFrameTable);
		this.fPanel.setPreferredSize(new Dimension(400, 200));
		stackFrameTable.setFillsViewportHeight(true);

		variablesTree = new VariablesTree();
		this.vPanel = new JScrollPane(variablesTree);
		this.vPanel.setPreferredSize(new Dimension(200, 200));

		this.splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
		this.splitPane.setBorder(BorderFactory
				.createLineBorder(Color.DARK_GRAY));
		this.splitPane.setLeftComponent(this.fPanel);
		this.splitPane.setRightComponent(this.vPanel);
		this.splitPane.setOneTouchExpandable(true);
		this.splitPane.setContinuousLayout(true);
		this.splitPane.setResizeWeight(0.5);
		this.add(this.splitPane, BorderLayout.CENTER);
		
		this.pack();
	}

	public StackFrameTable getStackFrameTable() {
		return stackFrameTable;
	}

	public VariablesTree getVariablesTree() {
		return variablesTree;
	}


}

class CloseListener extends WindowAdapter implements ActionListener {
	DebuggerFrame dFrame;

	CloseListener(DebuggerFrame dFrame) {
		this.dFrame = dFrame;
	}

	public void windowClosing(WindowEvent evt) {
		close();
	}

	public void actionPerformed(ActionEvent e) {
		close();
	}

	public void close() {
		dFrame.setVisible(false);
		Play.getPlay().getPlayFrame().getDebuggerFrameMenuItem().setSelected(false);
	}

}
