import theater.*;


/**
 * Die Klasse stellt eine Repraesentation des Spielfeldes (Schachbrett) dar.
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 1.0 (07.10.2009)
 *
 */
public class Spielfeld extends Stage {
    final static int MIN_SIZE = 1;
    final static int MAX_SIZE = 8;
    final static int DEF_SIZE = 5;
    final static int CELL_SIZE = 50;

    public Spielfeld() {
        super(MAX_SIZE, MAX_SIZE, CELL_SIZE);
        setBackground("kachel-weiss.gif");

        for (int r = 0; r < MAX_SIZE; r += 2) {
            for (int s = 1; s < MAX_SIZE; s += 2) {
                add(new KachelSchwarz(), s, r);
            }
        }

        for (int r = 1; r < MAX_SIZE; r += 2) {
            for (int s = 0; s < MAX_SIZE; s += 2) {
                add(new KachelSchwarz(), s, r);
            }
        }

        // erzeugt den Springer und platziert ihn oben links
        setSolist(Actor.createSolist(), 0, 0);

        setSize(DEF_SIZE);
    }

    void setSize(int size) {
        setSize(size, size);
    }

    int getSize() {
        return getNumberOfRows();
    }

    @Override
    public void remove(Component comp) {
        if (comp.getClass() == KachelSchwarz.class) {
            return; // Kacheln drfen nicht gelscht werden
        }

        // whrend eine Simulation luft, drfen Belegungen nur vom Springer
        // entfernt werden
        if (comp.getClass() == Belegung.class) {
            MyPerformance perf = (MyPerformance) Performance.getPerformance();
            Springer springer = (Springer) perf.getActiveStage().getSolist();

            if (perf.isRunning() && !springer.isActive()) {
                return;
            }
        }

        super.remove(comp);
    }
}
