import theater.*;


public class Belegung extends Prop {
    static TheaterImage image = new TheaterImage("belegung.gif");
    boolean added = false; // Flag, ob auf Spielfeld

    public Belegung() {
        setImage(image);
        setZCoordinate(1);
    }

    @Invisible
    @Override
    public void addedToStage(Stage stage) {
        added = true;

        if (stage.getComponentsAt(getColumn(), getRow(), 
                    Belegung.class).size() > 1) {
            stage.remove(this); // Feld bereits belegt 
        }
    }

    @Invisible
    @Override
    public void removedFromStage(Stage stage) {
        added = false;
    }

    @Invisible
    @Override
    public void setLocation(int col, int row) {
        Performance.getPerformance().lock();

        try {
            // gleiches Feld
            if ((col == getColumn()) && (row == getRow())) {
                return;
            }

            Spielfeld feld = (Spielfeld) getStage();

            // auerhalb des Spielfeldes
            if ((col < 0) || (row < 0) || (col >= feld.getSize()) ||
                    (row >= feld.getSize())) {
                return;
            }

            if (added) { // bereits auf dem Spielfeld

                // whrend eine Simulation luft, darf nicht verschoben werden
                MyPerformance perf = (MyPerformance) Performance.getPerformance();

                if (perf.isRunning()) {
                    return;
                }

                // Feld belegt
                if (getStage().getComponentsAt(col, row, Springer.class,
                            Belegung.class).size() >= 1) {
                    return;
                }
            }

            super.setLocation(col, row);
        } finally {
            Performance.getPerformance().unlock();
        }
    }
}
