package view;

import java.awt.Component;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;

import listener.ConstructorInvocation;
import listener.MethodInvocation;
import listener.MethodWithParamInvocation;
import listener.OpenEditorListener;
import listener.RemoveClassListener;
import model.Play;
import theater.Invisible;
import theater.Performance;
import theater.Stage;
import util.ResourceManager;
import util.Utils;

import compiler.CompileManager;

/**
 * Popup-Menu fr die Klassen im JTree
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class FilePopupMenu extends JPopupMenu {

	private JTree tree;

	public FilePopupMenu(JTree tree) {
		super();
		this.tree = tree;
	}

	public void show(Component invoker, int x, int y, int xOnScreen,
			int yOnScreen, String className) {

		Class<?> cls = null;
		try {
			Play play = Play.getPlay();
			ClassLoader cl = CompileManager.getCompileManager()
					.getClassLoader();
			cls = cl.loadClass(className);
			MethodComparator comparator = new MethodComparator();

			if (Utils.isDerivedClass(cls, theater.Component.class)
					|| Utils.isDerivedClass(cls, theater.Stage.class)) {

				Constructor<?>[] constructors = this.getConstructors(cls);
				for (Constructor<?> constructor : constructors) {
					Invisible inv = constructor.getAnnotation(Invisible.class);
					if (inv == null) {
						JMenuItem m = new JMenuItem(this
								.genConstructorName(constructor));
						if (constructor.getParameterTypes().length != 0
								|| this.isStageOrPerfClass(cls)
								&& play.getActivePerformance()
										.simulationRunning()
								|| play.getActiveStage() == null
								|| !CompileManager.getCompileManager()
										.wasSuccessfully()
								|| Utils.isDerivedClass(cls,
										theater.Actor.class)) {
							m.setEnabled(false);
						} else {
							m.addActionListener(new ConstructorInvocation(cls,
									constructor));
						}
						this.add(m);
					}
				}

				this.addSeparator();
			}

			Class<?> clsO = cls;
			do {
				clsO = clsO.getSuperclass();
				Method[] methods = this.getMethods(clsO);
				Arrays.sort(methods, comparator);
				JMenu menu = new JMenu(clsO.getName());
				for (Method method : methods) {
					Invisible inv = method.getAnnotation(Invisible.class);
					if (inv == null) {
						JMenuItem m = new JMenuItem(this.genMethodName(method));
						if (play.getActivePerformance().simulationRunning()
								|| play.getActiveStage() == null
								|| CompileManager.getCompileManager()
										.isCompilationRequired()) {
							m.setEnabled(false);
						} else {
							if (method.getParameterTypes().length == 0) {
								m.addActionListener(new MethodInvocation(
										method, null));
							} else {
								m
										.addActionListener(new MethodWithParamInvocation(
												method, null));
							}
						}
						menu.add(m);
					}
				}
				if (methods.length == 0) {
					JMenuItem m = new JMenuItem(ResourceManager
							.getResourceManager().getValue("nomethod"));
					m.setEnabled(false);
					menu.add(m);
				}
				this.add(menu);
			} while (clsO != Object.class);

			Method[] methods = this.getMethods(cls);
			Arrays.sort(methods, comparator);
			for (Method method : methods) {
				Invisible inv = method.getAnnotation(Invisible.class);
				if (inv == null) {
					JMenuItem m = new JMenuItem(this.genMethodName(method));
					if (play.getActivePerformance().simulationRunning()
							|| play.getActiveStage() == null
							|| !CompileManager.getCompileManager()
									.wasSuccessfully()) {
						m.setEnabled(false);
					} else {
						if (method.getParameterTypes().length == 0) {
							m.addActionListener(new MethodInvocation(method,
									null));
						} else {
							m.addActionListener(new MethodWithParamInvocation(
									method, null));
						}
					}
					this.add(m);
				}
			}

			this.addSeparator();

		} catch (ClassNotFoundException exc) {
			// wenn Klasse erzeugt aber noch nicht kompiliert wurde
		}

		JMenuItem openEditorMenuItem = new JMenuItem(ResourceManager
				.getResourceManager().getValue("filetree.openeditor"));
		openEditorMenuItem.addActionListener(new OpenEditorListener(xOnScreen,
				yOnScreen));
		this.add(openEditorMenuItem);

		JMenuItem removeClassMenuItem = new JMenuItem(ResourceManager
				.getResourceManager().getValue("filetree.deleteclass"));
		if (!Play.getPlay().getActivePerformance().simulationRunning()) {
			removeClassMenuItem.addActionListener(new RemoveClassListener(
					this.tree));
		} else {
			removeClassMenuItem.setEnabled(false);
		}
		this.add(removeClassMenuItem);

		/*
		 * todo JMenuItem setImageMenuItem = new JMenuItem(ResourceManager
		 * .getResourceManager().getValue("filetree.setimage")); todo
		 * setImageMenuItem.addActionListener(new SetImageListener(tree)); todo
		 * this.add(setImageMenuItem);
		 */

		this.show(invoker, x, y);
	}

	public Method[] getMethods(Class<?> c) {
		ArrayList<Method> res = new ArrayList<Method>();
		for (Method method : c.getDeclaredMethods()) {
			if (
			// Modifier.isPublic(method.getModifiers()) &&
			!Modifier.isAbstract(method.getModifiers())
					&& Modifier.isStatic(method.getModifiers())
			// && method.getDeclaringClass() == c
			) {
				res.add(method);
			}
		}
		return res.toArray(new Method[0]);
	}

	public Constructor<?>[] getConstructors(Class<?> c) {
		ArrayList<Constructor<?>> res = new ArrayList<Constructor<?>>();
		for (Constructor<?> method : c.getDeclaredConstructors()) {
			// if (Modifier.isPublic(method.getModifiers())
			// && method.getDeclaringClass() == c) {
			res.add(method);
			// }
		}
		return res.toArray(new Constructor<?>[0]);
	}

	public String genMethodName(Method method) {
		String str = new String();

		str += method.getReturnType().getName();
		str += " " + method.getName() + "(";

		Class<?>[] parameterTypes = method.getParameterTypes();
		for (int k = 0; k < parameterTypes.length; k++) {
			str += parameterTypes[k].getName();
			if (k < parameterTypes.length - 1) {
				str += ", ";
			}
		}
		str += " )";
		return str;
	}

	public String genConstructorName(Constructor<?> method) {
		String str = "new ";

		str += method.getName() + "(";

		Class<?>[] parameterTypes = method.getParameterTypes();
		for (int k = 0; k < parameterTypes.length; k++) {
			str += parameterTypes[k].getName();
			if (k < parameterTypes.length - 1) {
				str += ", ";
			}
		}
		str += " )";
		return str;
	}

	private boolean isStageOrPerfClass(Class<?> c) {
		return Utils.isDerivedClass(c, Stage.class)
				|| Utils.isDerivedClass(c, Performance.class);
	}

}
