package simulation.listener;

import theater.Component;
import theater.MouseInfo;
import theater.Stage;

public class MousePressedObject extends EventObject {

	public MousePressedObject(Component comp, MouseInfo mouseInfo) {
		super(comp, mouseInfo);
	}

	public MousePressedObject(Stage stage, MouseInfo mouseInfo) {
		super(stage, mouseInfo);
	}

	public void call() {
		MouseInfo eventInfo = (MouseInfo) this.eventInfo;
		if (comp != null) {
			if (comp.isHandlingMouseEvents() && !eventInfo.isConsumed()) {
				comp.mousePressed(eventInfo);
			}
		} else {
			if (stage.isHandlingMouseEvents() && !eventInfo.isConsumed()) {
				stage.mousePressed(eventInfo);
			}
		}
	}
}
