package simulation.listener;

import theater.Component;
import theater.MouseInfo;
import theater.Stage;

public class MouseDraggedObject extends EventObject {

	public MouseDraggedObject(Component comp, MouseInfo mouseInfo) {
		super(comp, mouseInfo);
	}

	public MouseDraggedObject(Stage stage, MouseInfo mouseInfo) {
		super(stage, mouseInfo);
	}

	public void call() {
		MouseInfo eventInfo = (MouseInfo) this.eventInfo;
		if (comp != null) {
			if (comp.isHandlingMouseEvents() && !eventInfo.isConsumed()) {
				comp.mouseDragged(eventInfo);
			}
		} else {
			if (stage.isHandlingMouseEvents() && !eventInfo.isConsumed()) {
				stage.mouseDragged(eventInfo);
			}
		}
	}
}
