package simulation.listener;

import theater.Component;
import theater.MouseInfo;
import theater.Stage;

public class MouseExitedObject extends EventObject {

	public MouseExitedObject(Component comp, MouseInfo mouseInfo) {
		super(comp, mouseInfo);
	}

	public MouseExitedObject(Stage stage, MouseInfo mouseInfo) {
		super(stage, mouseInfo);
	}

	public void call() {
		MouseInfo eventInfo = (MouseInfo) this.eventInfo;
		if (comp != null) {
			if (comp.isHandlingMouseEvents() && !eventInfo.isConsumed()) {
				comp.mouseExited(eventInfo);
			}
		} else {
			if (stage.isHandlingMouseEvents() && !eventInfo.isConsumed()) {
				stage.mouseExited(eventInfo);
			}
		}
	}
}
