package view;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import model.Play;

import util.ResourceManager;

import debugger.SolistDebugger;
import editor.SolistEditor;

/**
 * Popup-Menu fr Componenten
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class BreakpointsPopupMenu extends JPopupMenu {

	public BreakpointsPopupMenu(long line) {
		JMenuItem item = null;
		if (SolistDebugger.getSolistDebugger().isBreakpoint(line)) {
			item = new JMenuItem(ResourceManager.getResourceManager().getValue(
					"breakpoints.addrem.text")
					+ " "
					+ line
					+ " "
					+ ResourceManager.getResourceManager().getValue(
							"breakpoints.remove.text"));
			item.addActionListener(new RemoveBreakpointListener(line));
			this.add(item);
		} else {
			item = new JMenuItem(ResourceManager.getResourceManager().getValue(
					"breakpoints.addrem.text")
					+ " "
					+ line
					+ " "
					+ ResourceManager.getResourceManager().getValue(
							"breakpoints.add.text"));
			item.addActionListener(new AddBreakpointListener(line));
			this.add(item);
		}
		item = new JMenuItem(ResourceManager.getResourceManager().getValue(
				"breakpoints.clear.text"));
		item.addActionListener(new ClearBreakpointsListener());
		this.add(item);

	}
}

class AddBreakpointListener implements ActionListener {

	long line;

	AddBreakpointListener(long line) {
		this.line = line;
	}

	public void actionPerformed(ActionEvent e) {
		SolistDebugger.getSolistDebugger().addBreakpoint(line);
		SolistEditor.getSolistEditor().getEditor().getLineNumberPanel()
				.markLines();
		Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
				ResourceManager.getResourceManager().getValue(
						"breakpoint.added"));
	}

}

class RemoveBreakpointListener implements ActionListener {

	long line;

	RemoveBreakpointListener(long line) {
		this.line = line;
	}

	public void actionPerformed(ActionEvent e) {
		SolistDebugger.getSolistDebugger().removeBreakpoint(line);
		SolistEditor.getSolistEditor().getEditor().getLineNumberPanel()
				.markLines();
		Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
				ResourceManager.getResourceManager().getValue(
						"breakpoint.removed"));
	}

}

class ClearBreakpointsListener implements ActionListener {

	public void actionPerformed(ActionEvent e) {
		SolistDebugger.getSolistDebugger().clearBreakpoints();
		SolistEditor.getSolistEditor().getEditor().getLineNumberPanel()
				.markLines();
		Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
				ResourceManager.getResourceManager().getValue(
						"breakpoint.allremoved"));

	}

}
