import theater.*;

import javax.swing.JOptionPane;


/**
 * ActionHandler zum Eingeben eines Seeds fr Pseudo-Zufallszahlen
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 1.0 (22.10.2009)
 *
 */
public class Seed extends ActionHandler {
    public void handleAction(Stage stage, Actor solist) {
        GPerformance perf = (GPerformance) Performance.getPerformance();

        // whrend eine Simulation luft, kann die Aktion nicht ausgefhrt werden
        if (perf.isRunning()) {
            return;
        }

        World world = (World) stage;
        long oldSeed = world.getSeed();
        String input = JOptionPane.showInputDialog(null,
                "Seed (fr Pseudo-Zufallszahlen)", oldSeed);

        if (input == null) { // abbrechen

            return;
        }

        try {
            long newSeed = Long.parseLong(input);
            world.setSeed(newSeed);
        } catch (Throwable th) {
            return;
        }
    }
}
