import theater.*;

import java.util.List;


/**
 * Objekte dieser Requisitenklasse reprsentieren eine Mcke
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 1.0 (24.09.2009)
 *
 */
public class Muecke extends Prop {
    public Muecke() {
        setImage("muecke.gif");

        // Mcke sitzt immer vor Wasser aber hinter dem Frosch
        setZCoordinate(1);
    }

    // berschreibt die geerbte Methode, die zum Setzen der Position dient
    @Invisible // soll nicht im Popup-Men sichtbar sein

    public void setLocation(int col, int row) {
        Performance.getPerformance().lock();

        try {
            // neue Kachel ist bereits die aktuelle Kachel
            if ((this.getColumn() == col) && (this.getRow() == row)) {
                return;
            }

            // auerhalb des Territoriums
            if ((col < 0) || (row < 0) ||
                    (col >= getStage().getNumberOfColumns()) ||
                    (row >= getStage().getNumberOfRows())) {
                return;
            }

            List<Component> comps = getStage()
                                        .getComponentsAt(col, row, Muecke.class);

            if (comps.size() > 0) {
                // bereits Muecke da
                return;
            }

            super.setLocation(col, row);
        } finally {
            Performance.getPerformance().unlock();
        }
    }
}
